/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.Widevine;
import com.teamdev.jxbrowser.engine.WidevineActivationStatus;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.WidevineActivationStatusValue;
import com.teamdev.jxbrowser.internal.rpc.WidevineStub;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import java.util.concurrent.CompletableFuture;

final class WidevineImpl
extends CloseableImpl
implements Widevine {
    private final EngineImpl engine;
    private final ServiceConnectionImpl<WidevineStub> rpc;

    WidevineImpl(EngineImpl engine) {
        this.engine = engine;
        this.rpc = new ServiceConnectionImpl<WidevineStub>(engine.id(), engine.connection(), WidevineStub::new);
    }

    @Override
    public Engine engine() {
        return this.engine;
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }

    @Override
    public boolean isActivated() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isActivated, this.engine.id())).getValue();
    }

    @Override
    public CompletableFuture<WidevineActivationStatus> activate() {
        this.checkNotClosed();
        if (Environment.isLinux() && EngineImpl.tempUserDataDirs.list().contains(this.engine.options().userDataDir())) {
            throw new IllegalStateException("Widevine component cannot be installed on Linux without a custom user data directory. Please specify a user data directory through the engine options.");
        }
        final CompletableFuture<WidevineActivationStatus> result = new CompletableFuture<WidevineActivationStatus>();
        this.rpc.invokeAsync(this.rpc.stub()::activate, this.engine.id(), new RpcCallback<WidevineActivationStatusValue>(){

            @Override
            public void onNext(WidevineActivationStatusValue value) {
                switch (value.getValue()) {
                    case ACTIVATED: {
                        result.complete(WidevineActivationStatus.ACTIVATED);
                        break;
                    }
                    case RESTART_REQUIRED: {
                        result.complete(WidevineActivationStatus.RESTART_REQUIRED);
                        break;
                    }
                    case ACTIVATION_FAILED: {
                        result.complete(WidevineActivationStatus.ACTIVATION_FAILED);
                        break;
                    }
                    case NOT_SUPPORTED: {
                        result.complete(WidevineActivationStatus.NOT_SUPPORTED);
                        break;
                    }
                    default: {
                        Logger.error("Unknown Widevine installation status: {0}", value);
                        result.cancel(false);
                    }
                }
            }

            @Override
            public void onError(Throwable t) {
                result.cancel(false);
            }
        });
        return result;
    }
}

