/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.frame.internal.convert.CollectionValue;
import com.teamdev.jxbrowser.js.JsArray;
import com.teamdev.jxbrowser.js.internal.JsArrayImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.List;

final class ArrayValue
extends CollectionValue {
    ArrayValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.ARRAY);
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return ImmutableList.of(List.class, JsArray.class);
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(this.isConvertibleTo(type), "Cannot convert the value to: " + type);
        JsArrayImpl jsArray = this.getOrCreateJsObject(this.jsValue().getArray().getId(), JsArrayImpl.class);
        if (type.isAssignableFrom(List.class)) {
            return (T)jsArray.toList();
        }
        return (T)jsArray;
    }
}

