/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.js.internal.rpc.BigIntValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class BigInt {
    private static final int WORD_SIZE = 8;

    private BigInt() {
    }

    public static BigIntValue toJs(BigInteger bigInteger) {
        int signBit = bigInteger.signum() < 0 ? 1 : 0;
        byte[] magnitude = bigInteger.abs().toByteArray();
        byte[] padded = BigInt.padToWordSize(magnitude);
        List<Long> words = BigInt.toLittleEndianWords(padded);
        return BigIntValue.newBuilder().setSignBit(signBit).addAllWord(words).build();
    }

    static BigInteger toJava(BigIntValue bigInt) {
        int signBit = bigInt.getSignBit();
        List<Long> words = bigInt.getWordList();
        byte[] magnitude = BigInt.toBigEndianBytes(words);
        int sign = signBit == 0 ? 1 : -1;
        return new BigInteger(sign, magnitude);
    }

    private static byte[] padToWordSize(byte[] magnitude) {
        int fullLength = (magnitude.length + 8 - 1) / 8 * 8;
        byte[] padded = new byte[fullLength];
        System.arraycopy(magnitude, 0, padded, fullLength - magnitude.length, magnitude.length);
        return padded;
    }

    private static List<Long> toLittleEndianWords(byte[] padded) {
        ArrayList<Long> words = new ArrayList<Long>();
        for (int i = 0; i < padded.length; i += 8) {
            long word = 0L;
            for (int j = 0; j < 8; ++j) {
                word = word << 8 | (long)padded[i + j] & 0xFFL;
            }
            words.add(0, word);
        }
        return words;
    }

    private static byte[] toBigEndianBytes(List<Long> words) {
        byte[] magnitude = new byte[words.size() * 8];
        for (int i = 0; i < words.size(); ++i) {
            long word = words.get(i);
            for (int j = 0; j < 8; ++j) {
                int shift = (7 - j) * 8;
                int index = magnitude.length - (i + 1) * 8 + j;
                magnitude[index] = (byte)(word >>> shift);
            }
        }
        return magnitude;
    }
}

