/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.engine.ChromiumBinariesDeliveryException;
import com.teamdev.jxbrowser.internal.BinariesListing;
import com.teamdev.jxbrowser.internal.JavaBinaryVerifier;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.logging.Logger;
import java.nio.file.Path;
import java.util.List;

public final class BinariesIntegrity {
    private final Path chromiumDir;
    private final List<BinariesListing> listings;

    public BinariesIntegrity(List<BinariesListing> listings, Path chromiumDir) {
        this.listings = ImmutableList.copyOf(listings);
        this.chromiumDir = chromiumDir;
    }

    public void verifyOrThrow() {
        if (!this.verify()) {
            throw new ChromiumBinariesDeliveryException("Failed to check integrity of the Chromium binaries.");
        }
    }

    public boolean verify() {
        if (SystemProperties.hasProperty("jxbrowser.chromium.binaries.verification.disabled")) {
            Logger.debug("Skip checking binaries integrity, because it is explicitly disabled.");
            return true;
        }
        Logger.debug("Checking binaries integrity in {0}...", this.chromiumDir);
        JavaBinaryVerifier verifier = new JavaBinaryVerifier();
        return verifier.verify(this.chromiumDir, this.listings);
    }
}

