/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.Language;
import com.teamdev.jxbrowser.engine.SandboxNotSupportedException;
import com.teamdev.jxbrowser.internal.ChromiumProcess;
import com.teamdev.jxbrowser.internal.ChromiumSwitches;
import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.ScaleFactor;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

final class ChromiumProcessLinux
extends ChromiumProcess {
    private static final String NO_SANDBOX = "--no-sandbox";
    private static final String CRASHPAD_HANDLER = "chrome_crashpad_handler";
    private static final String USER_NAMESPACES_NOT_SUPPORTED_MESSAGE = "The current environment does not support creating processes within a new usernamespace. As a result, Chromium cannot be launched in sandbox mode.See: https://teamdev.com/jxbrowser/docs/guides/chromium/#sandbox";

    ChromiumProcessLinux(int port, Path chromiumDir) {
        super(port, chromiumDir);
    }

    private static void configureLanguage(ProcessBuilder processBuilder, Language language) {
        Map<String, String> environment = processBuilder.environment();
        environment.put("LANGUAGE", language.toString());
    }

    @Override
    protected Optional<String> defaultCrashDumpDir() {
        return Optional.of(Environment.userHomeDir().resolve(".config").resolve("jxbrowser").resolve(VersionInfo.version()).resolve("crash-reports").toAbsolutePath().toString());
    }

    @Override
    protected Collection<String> platformCommandLineArgs(EngineOptions engineOptions) {
        ChromiumSwitches switches = new ChromiumSwitches();
        if (!this.isSandboxDisabled(engineOptions) && !ToolkitLibrary.instance().canCreateProcessInNewUserNamespace()) {
            throw new SandboxNotSupportedException(USER_NAMESPACES_NOT_SUPPORTED_MESSAGE);
        }
        if (!ScaleFactor.isForcedByChromiumSwitch(engineOptions.switches())) {
            switches.add("force-device-scale-factor", ScaleFactor.forcedJavaScaleFactor());
        }
        return switches.toList();
    }

    @Override
    protected void preProcessRun(ProcessBuilder processBuilder, EngineOptions options) throws IOException {
        super.preProcessRun(processBuilder, options);
        ChromiumProcessLinux.configureLanguage(processBuilder, options.language());
        Files.restorePermissionsForFile(this.executable().path());
        Files.restorePermissionsForFile(this.workingDir().resolve(CRASHPAD_HANDLER));
    }

    private boolean isSandboxDisabled(EngineOptions options) {
        return options.isSandboxDisabled() || options.switches().contains(NO_SANDBOX);
    }
}

