/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.Display;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class DisplayWatcher<T> {
    private final Consumer<Display> observer;
    private Display display;

    protected DisplayWatcher(Consumer<Display> observer) {
        this.observer = observer;
    }

    protected DisplayWatcher(Consumer<Display> observer, Display initialDisplay) {
        this.observer = observer;
        this.display = initialDisplay;
    }

    public abstract void attach(@Nullable T var1);

    public abstract void detach();

    protected void changeDisplay(Display display) {
        if (this.isDisplayChanged(display)) {
            this.display = display;
            this.notifyDisplayChanged(display);
        }
    }

    private void notifyDisplayChanged(Display display) {
        this.observer.accept(display);
    }

    private boolean isDisplayChanged(Display newDisplay) {
        return this.display == null || !this.display.equals(newDisplay);
    }

    public Display display() {
        return this.display;
    }
}

