/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class HashedData {
    private static final char[] HEX_CODE = "0123456789ABCDEF".toCharArray();
    private final byte[] digestBytes;

    private HashedData(byte[] digestBytes) {
        this.digestBytes = digestBytes;
    }

    static HashedData fromBytes(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(bytes);
        byte[] digestBytes = digest.digest();
        return new HashedData(digestBytes);
    }

    String digestStr() {
        return HashedData.printHexBinary(this.digestBytes);
    }

    private static String printHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(HEX_CODE[b >> 4 & 0xF]);
            r.append(HEX_CODE[b & 0xF]);
        }
        return r.toString();
    }
}

