/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.ChromiumSwitches;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import java.util.List;
import java.util.Optional;

public final class ScaleFactor {
    private static final String SWING_SCALE_PROPERTY = "sun.java2d.uiScale";
    private static final String JAVAFX_SCALE_PROPERTY = "glass.gtk.uiScale";
    static final double DEFAULT_SCALE_FACTOR = 1.0;

    private ScaleFactor() {
    }

    public static double forDisplay(String displayId) {
        return ToolkitLibrary.instance().getScaleFactorForDisplay(displayId);
    }

    public static Optional<Double> fromChromiumSwitches(List<String> switches) {
        String scaleFactorSwitch = ChromiumSwitches.SWITCH_PREFIX + "force-device-scale-factor=";
        for (String chromiumSwitch : switches) {
            if (!chromiumSwitch.startsWith(scaleFactorSwitch)) continue;
            return ScaleFactor.chromiumSwitchValueDouble(chromiumSwitch);
        }
        return Optional.empty();
    }

    static double forPrimaryDisplay() {
        String displayId = ToolkitLibrary.instance().getPrimaryDisplayId();
        return ScaleFactor.forDisplay(displayId);
    }

    private static Optional<Double> chromiumSwitchValueDouble(String switcher) {
        int equalsIndex = switcher.indexOf("=");
        if (equalsIndex == -1) {
            return Optional.empty();
        }
        String switchStringValue = switcher.substring(equalsIndex + 1);
        if (switchStringValue.isEmpty()) {
            return Optional.empty();
        }
        return ScaleFactor.stringToDouble(switchStringValue);
    }

    private static Optional<Double> stringToDouble(String value) {
        try {
            return Optional.of(Double.parseDouble(value));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    static boolean isForcedByChromiumSwitch(List<String> switches) {
        return ScaleFactor.fromChromiumSwitches(switches).isPresent();
    }

    static double forcedJavaScaleFactor() {
        Preconditions.checkState(Environment.isLinux());
        double javaScaleFactor = ToolkitLibrary.instance().getScaleFactor();
        if (SystemProperties.hasProperty(SWING_SCALE_PROPERTY)) {
            javaScaleFactor = Double.parseDouble(System.getProperty(SWING_SCALE_PROPERTY));
        }
        if (SystemProperties.hasProperty(JAVAFX_SCALE_PROPERTY)) {
            javaScaleFactor = Double.parseDouble(System.getProperty(JAVAFX_SCALE_PROPERTY));
        }
        return javaScaleFactor;
    }
}

