/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.internal.platform.win.MessageLoopHelper;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.os.Environment;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class CommonThreadResponseConsumer<T>
implements RpcCallback<T> {
    private static final int TIMEOUT_DURATION = 100;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<T> response = new AtomicReference();
    private final AtomicReference<Throwable> exception = new AtomicReference();

    CommonThreadResponseConsumer() {
    }

    @Override
    public void onNext(T t) {
        this.response.set(t);
        this.latch.countDown();
    }

    @Override
    public void onError(Throwable t) {
        this.exception.set(t);
        this.latch.countDown();
    }

    public T await() {
        try {
            if (Environment.isWindows() && MessageLoopHelper.isMessageLoopThread()) {
                while (!this.latch.await(100L, TimeUnit.MILLISECONDS)) {
                    MessageLoopHelper.runNestedMessageLoop();
                }
            } else {
                this.latch.await();
            }
        }
        catch (InterruptedException e) {
            this.exception.set(e);
        }
        if (this.exception.get() != null) {
            throw new IllegalStateException("Failed to receive the response.", this.exception.get());
        }
        return this.response.get();
    }
}

