/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Empty;
import com.teamdev.jxbrowser.deps.com.google.protobuf.InvalidProtocolBufferException;
import com.teamdev.jxbrowser.engine.IpcSetupFailureException;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.internal.rpc.ConnectionCreated;
import com.teamdev.jxbrowser.internal.rpc.ConnectionId;
import com.teamdev.jxbrowser.internal.rpc.ConnectionType;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionClosed;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionEvent;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionChecker;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionClosureException;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcConnection;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryTransport;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.ParametersAreNonnullByDefault;

public final class ConnectionServer
implements Observable<ConnectionEvent> {
    private static final int DEFAULT_AWAIT_CONNECTION_TIMEOUT_IN_SECONDS = 45;
    private final ServerSocket serverSocket;
    private final ObservableHelper<ConnectionEvent> observable;
    private final Map<ConnectionId, Connection> activeConnections;
    private final Lock lock = new ReentrantLock();
    private final Condition connectionAdded = this.lock.newCondition();
    private State state;

    public ConnectionServer() {
        this.observable = new ObservableHelper();
        this.activeConnections = new HashMap<ConnectionId, Connection>();
        try {
            Logger.debug("Starting server...");
            this.serverSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            Logger.debug(() -> "Starting server at port " + this.port() + "... [OK]");
        }
        catch (IOException e) {
            throw new IpcSetupFailureException("Failed to initialize the connection manager", e);
        }
        this.state = State.RUNNING;
        Thread thread = new Thread(new AcceptConnections());
        thread.setName("IPC Server Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public int port() {
        return this.serverSocket.getLocalPort();
    }

    private boolean isClosed() {
        return this.serverSocket.isClosed();
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.state = State.CLOSING;
        Logger.debug("Stopping server...");
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new ConnectionClosureException("Stopping server... [FAILED]", e);
        }
        Logger.debug("Stopping server... [OK]");
        this.state = State.CLOSED;
    }

    public Optional<Connection> awaitConnection(ConnectionId connectionId) {
        this.lock.lock();
        try {
            while (!this.activeConnections.containsKey(connectionId)) {
                Logger.debug("Awaiting connection with id: {0}...", connectionId.getUuid());
                if (!this.connectionAdded.await(45L, TimeUnit.SECONDS)) continue;
            }
            Optional<Connection> optional = Optional.ofNullable(this.activeConnections.get(connectionId));
            return optional;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("The current thread has been interrupted.", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Connection> getConnection(ConnectionType type) {
        this.lock.lock();
        try {
            for (Connection connection : this.activeConnections.values()) {
                if (!connection.type().equals(type)) continue;
                Optional<Connection> optional = Optional.of(connection);
                return optional;
            }
        }
        finally {
            this.lock.unlock();
        }
        return Optional.empty();
    }

    @Override
    @ParametersAreNonnullByDefault
    public <E extends ConnectionEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.observable.on(eventClass, observer);
    }

    private static enum State {
        RUNNING,
        CLOSING,
        CLOSED;

    }

    private class AcceptConnections
    implements Runnable {
        private AcceptConnections() {
        }

        @Override
        public void run() {
            Logger.debug(() -> "Accepting connections...");
            while (!ConnectionServer.this.serverSocket.isClosed()) {
                try {
                    Socket socket = ConnectionServer.this.serverSocket.accept();
                    Logger.debug(() -> "Accepting connection...");
                    Connection connection = this.acceptConnection(socket);
                    this.notifyConnectionEstablished(socket);
                    this.startConnectionChecker(socket, connection);
                    Logger.debug(() -> "Accepted: " + connection);
                }
                catch (InvalidProtocolBufferException e) {
                    Logger.debug("Unrecognized connection attempt", e);
                }
                catch (IOException e) {
                    if (ConnectionServer.this.state != State.RUNNING) continue;
                    Logger.error("Failed to accept connection", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection acceptConnection(Socket socket) throws IOException {
            ConnectionCreated connectionCreated = ConnectionCreated.parseDelimitedFrom(socket.getInputStream());
            SharedMemoryTransport transport = new SharedMemoryTransport(connectionCreated.getConnectionData().toByteArray());
            RpcConnection connection = new RpcConnection(transport);
            ConnectionId connectionId = connection.id();
            connection.on(ConnectionClosed.class, event -> {
                ConnectionServer.this.lock.lock();
                try {
                    ConnectionServer.this.activeConnections.remove(connectionId);
                }
                finally {
                    ConnectionServer.this.lock.unlock();
                }
            });
            ConnectionServer.this.lock.lock();
            try {
                ConnectionServer.this.activeConnections.put(connectionId, connection);
                ConnectionServer.this.observable.notifyObservers(new com.teamdev.jxbrowser.internal.rpc.event.ConnectionCreated(connection));
                ConnectionServer.this.connectionAdded.signal();
            }
            finally {
                ConnectionServer.this.lock.unlock();
            }
            return connection;
        }

        private void startConnectionChecker(Socket socket, Connection connection) {
            Thread thread = new Thread((Runnable)new ConnectionChecker(socket, connection), "Socket Connection Checker: " + connection.id().getUuid());
            thread.setDaemon(false);
            thread.start();
        }

        private void notifyConnectionEstablished(Socket socket) throws IOException {
            Empty connectionEstablishedRequest = Protobuf.empty();
            connectionEstablishedRequest.writeDelimitedTo(socket.getOutputStream());
        }
    }
}

