/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.xz;

import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.xz.ResourceExtractor;
import com.teamdev.jxbrowser.internal.xz.ResourceLocator;
import com.teamdev.jxbrowser.os.Environment;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class JniResourceExtractor
implements ResourceExtractor {
    JniResourceExtractor() {
    }

    @Override
    public void extract(String resourceName, Path destFile) throws IOException {
        if (!Environment.isLinux()) {
            throw new IllegalStateException("This extraction algorithm does not support the current OS.");
        }
        if (java.nio.file.Files.exists(destFile, new LinkOption[0])) {
            Files.deleteFile(destFile);
        }
        java.nio.file.Files.createFile(destFile, new FileAttribute[0]);
        URL resourceUrl = ResourceLocator.loadResource(resourceName);
        DataInputStream stream = new DataInputStream(resourceUrl.openStream());
        byte[] data = new byte[stream.available()];
        stream.readFully(data);
        boolean result = ToolkitLibrary.instance().writeToFile(data, destFile.toFile().getAbsolutePath());
        if (!result) {
            throw new IOException("Failed to extract the resource: " + resourceUrl);
        }
    }
}

