/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableSet;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.frame.internal.rpc.CanAccessMember;
import com.teamdev.jxbrowser.frame.internal.rpc.GetObjectType;
import com.teamdev.jxbrowser.frame.internal.rpc.InvokeMethod;
import com.teamdev.jxbrowser.frame.internal.rpc.Member;
import com.teamdev.jxbrowser.frame.internal.rpc.MemberAccessError;
import com.teamdev.jxbrowser.frame.internal.rpc.MemberType;
import com.teamdev.jxbrowser.frame.internal.rpc.MemberUpdateError;
import com.teamdev.jxbrowser.frame.internal.rpc.ReadField;
import com.teamdev.jxbrowser.frame.internal.rpc.UpdateField;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.reflect.Fields;
import com.teamdev.jxbrowser.internal.reflect.Methods;
import com.teamdev.jxbrowser.js.JsAccessible;
import com.teamdev.jxbrowser.js.JsAccessibleTypes;
import com.teamdev.jxbrowser.js.JsFunctionCallback;
import com.teamdev.jxbrowser.js.internal.JsAccessibleMethod;
import com.teamdev.jxbrowser.js.internal.JsCallbackResponses;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.NumberValue;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class JsAccessibleObject {
    private final Object object;

    JsAccessibleObject(Object object) {
        this.object = Preconditions.checkNotNull(object);
    }

    public CanAccessMember.Response canAccessMember(CanAccessMember.Request params) {
        if (this.isFunction()) {
            return JsCallbackResponses.canAccessMemberResponse(MemberType.METHOD);
        }
        Member member = params.getMember();
        if (member.isIndexed()) {
            return JsCallbackResponses.canAccessMemberResponse(MemberAccessError.MEMBER_NOT_FOUND);
        }
        String memberName = member.getName();
        Set<Method> methods = Methods.findDeclaredMethods(this.object.getClass(), method -> method.getName().equals(memberName));
        Optional<Field> field = Fields.findField(this.object.getClass(), memberName);
        if (methods.isEmpty() && !field.isPresent()) {
            return JsCallbackResponses.canAccessMemberResponse(MemberAccessError.MEMBER_NOT_FOUND);
        }
        boolean isAnyMethodAccessible = methods.stream().anyMatch(JsAccessibleObject::isAccessibleFromJs);
        boolean isFieldAccessible = field.map(JsAccessibleObject::isAccessibleFromJs).orElse(false);
        if (isAnyMethodAccessible && isFieldAccessible) {
            return JsCallbackResponses.canAccessMemberResponse(MemberAccessError.AMBIGUOUS_MEMBERS);
        }
        if (isFieldAccessible) {
            return JsCallbackResponses.canAccessMemberResponse(MemberType.FIELD);
        }
        if (isAnyMethodAccessible) {
            return JsCallbackResponses.canAccessMemberResponse(MemberType.METHOD);
        }
        return JsCallbackResponses.canAccessMemberResponse(MemberAccessError.MEMBER_INACCESSIBLE);
    }

    public InvokeMethod.Response invokeMethod(JsContext jsContext, InvokeMethod.Request params) {
        try {
            ArrayList<JsValue> args = new ArrayList<JsValue>(params.getArgList());
            if (this.isFunction()) {
                return JsCallbackResponses.invokeMethodResponse(JsValue.from(jsContext, this.invokeAsFunction(args)));
            }
            if (JsAccessibleObject.isSymbolRequest(params)) {
                return JsCallbackResponses.invokeMethodResponse(JsValue.from(jsContext, this.toString(args)));
            }
            Object result = this.invokeMethod(params.getMethodName(), args);
            return JsCallbackResponses.invokeMethodResponse(JsValue.from(jsContext, result));
        }
        catch (Exception e) {
            return JsCallbackResponses.invokeMethodErrorResponse(e);
        }
    }

    public UpdateField.Response updateField(UpdateField.Request params) {
        Member jsField = params.getField();
        if (jsField.isIndexed()) {
            return JsCallbackResponses.updateFieldResponse(MemberAccessError.MEMBER_INACCESSIBLE);
        }
        return Fields.findField(this.object.getClass(), jsField.getName()).filter(JsAccessibleObject::isAccessibleFromJs).map(field -> this.setFieldValue(this.object, (Field)field, params.getValue())).orElse(JsCallbackResponses.updateFieldResponse(MemberAccessError.MEMBER_INACCESSIBLE));
    }

    public ReadField.Response readField(JsContext jsContext, ReadField.Request params) {
        Member jsField = params.getField();
        if (jsField.isIndexed()) {
            return JsCallbackResponses.readFieldResponse(MemberAccessError.MEMBER_INACCESSIBLE);
        }
        return Fields.findField(this.object.getClass(), jsField.getName()).filter(JsAccessibleObject::isAccessibleFromJs).map(field -> this.readFieldValue(jsContext, this.object, (Field)field)).orElse(JsCallbackResponses.readFieldResponse(MemberAccessError.MEMBER_INACCESSIBLE));
    }

    public GetObjectType.Response objectType() {
        return JsCallbackResponses.getObjectTypeResponse(this.object.getClass().getName());
    }

    public Object object() {
        return this.object;
    }

    boolean isAccessible() {
        return !this.accessibleMethods().isEmpty() || !this.accessibleFields().isEmpty();
    }

    Set<JsAccessibleMethod> accessibleMethods() {
        return Methods.findDeclaredMethods(this.object.getClass(), JsAccessibleObject::isAccessibleFromJs).stream().map(JsAccessibleMethod::new).collect(ImmutableSet.toImmutableSet());
    }

    Set<Field> accessibleFields() {
        return Fields.findFields(this.object.getClass(), JsAccessibleObject::isAccessibleFromJs);
    }

    boolean isFunction() {
        return this.object instanceof JsFunctionCallback;
    }

    @Nullable
    private Object invokeAsFunction(List<JsValue> args) {
        Object[] functionArgs = args.stream().map(JavaValue::from).map(JavaValue::toObject).toArray();
        return ((JsFunctionCallback)this.object).invoke(functionArgs);
    }

    @Nullable
    private Object invokeMethod(String methodName, List<JsValue> args) throws ReflectiveOperationException {
        List params = args.stream().map(JavaValue::from).collect(ImmutableList.toImmutableList());
        Set methods = this.accessibleMethods().stream().filter(method -> method.name().equals(methodName)).filter(method -> method.canAccept(params)).collect(ImmutableSet.toImmutableSet());
        if (methods.size() > 1) {
            throw JsAccessibleObject.ambiguousMethodsException(methods);
        }
        if (methods.isEmpty()) {
            throw JsAccessibleObject.unsupportedSignatureException(methodName, args);
        }
        JsAccessibleMethod method2 = (JsAccessibleMethod)methods.iterator().next();
        return method2.invoke(this.object, params);
    }

    private UpdateField.Response setFieldValue(Object javaObject, Field field, JsValue value) {
        Object fieldValue = JavaValue.from(value.impl()).toObject();
        if (fieldValue == null && field.getType().isPrimitive()) {
            return JsCallbackResponses.updateFieldResponse(MemberUpdateError.WRITING_NULL);
        }
        try {
            field.set(javaObject, fieldValue);
        }
        catch (IllegalAccessException e) {
            return JsCallbackResponses.updateFieldResponse(MemberAccessError.MEMBER_INACCESSIBLE);
        }
        catch (IllegalArgumentException e) {
            return JsCallbackResponses.updateFieldResponse(MemberUpdateError.CONVERSION_ERROR);
        }
        return JsCallbackResponses.updateFieldSuccessResponse();
    }

    private ReadField.Response readFieldValue(JsContext jsContext, Object javaObject, Field field) {
        try {
            return JsCallbackResponses.readFieldResponse(JsValue.from(jsContext, field.get(javaObject)));
        }
        catch (IllegalAccessException e) {
            return JsCallbackResponses.readFieldResponse(MemberAccessError.MEMBER_INACCESSIBLE);
        }
    }

    private Object toString(List<JsValue> args) {
        Preconditions.checkArgument(args.size() == 1);
        JsValue hint = args.get(0);
        Preconditions.checkArgument(hint.impl().getValueCase() == JsValue.ValueCase.STRING_VALUE);
        String hintValue = hint.impl().getStringValue();
        if (hintValue.equalsIgnoreCase("number")) {
            return Double.NaN;
        }
        if (hintValue.equalsIgnoreCase("string")) {
            return "[object " + this.object.getClass().getName() + "]";
        }
        if (hintValue.equalsIgnoreCase("default")) {
            return "[object " + this.object.getClass().getName() + "]";
        }
        throw new IllegalArgumentException("Unsupported 'Symbol.toPrimitive' hint: " + hintValue);
    }

    private static <T extends java.lang.reflect.Member & AnnotatedElement> boolean isAccessibleFromJs(T member) {
        int memberModifiers = member.getModifiers();
        if (!Modifier.isPublic(memberModifiers) || Modifier.isStatic(memberModifiers)) {
            return false;
        }
        Class<?> declaringClass = member.getDeclaringClass();
        if (!Modifier.isPublic(declaringClass.getModifiers())) {
            return false;
        }
        boolean isMemberAccessible = ((AnnotatedElement)member).isAnnotationPresent(JsAccessible.class);
        boolean isClassAccessible = JsAccessibleTypes.isAccessible(declaringClass) || declaringClass.isAnnotationPresent(JsAccessible.class);
        return isMemberAccessible || isClassAccessible || SystemProperties.hasProperty("jxbrowser.jsaccessible.disabled");
    }

    private static boolean isSymbolRequest(InvokeMethod.Request params) {
        return params.getMethodName().equalsIgnoreCase("Symbol.toPrimitive");
    }

    private static IllegalStateException ambiguousMethodsException(Set<JsAccessibleMethod> satisfiedMethods) {
        StringBuilder builder = new StringBuilder("Method invocation failed. Several methods with the suitable signature are found.");
        satisfiedMethods.forEach(method -> builder.append(String.format("%n\t%s", method)));
        throw new IllegalStateException(builder.toString());
    }

    private static IllegalStateException unsupportedSignatureException(String methodName, List<JsValue> args) {
        StringBuilder builder = new StringBuilder("Unsupported method signature: ");
        builder.append(methodName);
        builder.append("(");
        Iterator<JsValue> iterator = args.iterator();
        while (iterator.hasNext()) {
            JsValue arg = iterator.next();
            switch (arg.impl().getValueCase()) {
                case BOOL_VALUE: {
                    builder.append("Object|Boolean|boolean");
                    break;
                }
                case NUMBER_VALUE: {
                    NumberValue.ValueCase valueCase = arg.impl().getNumberValue().getValueCase();
                    if (valueCase == NumberValue.ValueCase.PRIMITIVE_VALUE) {
                        builder.append("Object|Number|Double|double");
                        break;
                    }
                    if (valueCase == NumberValue.ValueCase.BIG_INT_VALUE) {
                        builder.append("Object|Number|BigInteger");
                        break;
                    }
                    throw new IllegalStateException("Number value is not set: " + arg.impl());
                }
                case STRING_VALUE: {
                    builder.append("Object|String");
                    break;
                }
                case NODE_INFO: 
                case OBJECT_ID: 
                case OBJECT_PROXY_ID: {
                    builder.append("Object");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported JsValue: " + arg);
                }
            }
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(")");
        return new IllegalStateException(builder.toString());
    }
}

