/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.os;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.engine.internal.PosixCommandLookup;
import com.teamdev.jxbrowser.internal.Version;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.EnvironmentException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class Environment {
    private static final Version MIN_WIN_VERSION = new Version(10, 0);
    private static final Version MIN_MAC_VERSION = new Version(12, 0);
    private static final String ARM64_SUCCESSFUL_OUTPUT = "1";

    public static boolean isWindows() {
        return Environment.osName().startsWith("Windows");
    }

    public static boolean isWindows64() {
        return System.getenv("ProgramFiles(x86)") != null;
    }

    public static boolean isMac() {
        return Environment.osName().startsWith("Mac");
    }

    public static boolean isLinux() {
        return Environment.osName().startsWith("Linux");
    }

    public static boolean is64Bit() {
        String arch = Environment.jvmArch();
        return "amd64".equals(arch) || "x86_64".equals(arch) || "aarch64".equals(arch);
    }

    public static boolean is32Bit() {
        String arch = Environment.jvmArch();
        return "x86".equals(arch) || "i386".equals(arch);
    }

    public static boolean isArm() {
        String arch = Environment.jvmArch();
        return "aarch64".equals(arch) || "arm".equals(arch);
    }

    public static boolean isAppleSilicon() {
        if (!Environment.isMac()) {
            return false;
        }
        Optional<Path> sysctl = PosixCommandLookup.findCommandExecutable("sysctl");
        if (sysctl.isEmpty()) {
            Logger.warn("Couldn't find the `sysctl` utility.");
            return false;
        }
        try {
            Process process = Runtime.getRuntime().exec(sysctl.get() + " -n hw.optional.arm64");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            String architecture = reader.readLine();
            if (architecture != null) {
                Logger.debug("sysctl output: {0}", architecture);
                return architecture.equals(ARM64_SUCCESSFUL_OUTPUT);
            }
        }
        catch (IOException e) {
            Logger.warn("Failed to detect Mac architecture.", e);
        }
        return false;
    }

    public static Path defaultChromiumDir() {
        AtomicReference<Path> appDir = new AtomicReference<Path>(Environment.userTempDir());
        if (Environment.isWindows()) {
            Environment.win32UserAppDataLocalDir().ifPresent(appDir::set);
        }
        return appDir.get().resolve("JxBrowser").resolve(VersionInfo.version()).toAbsolutePath();
    }

    public static void checkEnvironment() {
        if (!Environment.isOsSupported()) {
            String message = "Unsupported operating system. Supported OS: Windows 10 and higher, Windows Server 2016 and higher, macOS 12.0 and higher, Linux 64-bit. Current OS: " + Environment.osName() + ", version: " + Environment.osVersion();
            throw new EnvironmentException(message);
        }
        if (!Environment.isJreSupported()) {
            throw new EnvironmentException("Unsupported JRE version. Supported versions: JRE 17 and higher. Current version: " + Environment.jreVersion());
        }
    }

    public static boolean isSupported() {
        return Environment.isOsSupported() && Environment.isJreSupported();
    }

    public static void traceEnvironment() {
        if (!Logger.isInfoEnabled()) {
            return;
        }
        Logger.info("{0} {1}", Environment.osName(), Environment.osVersion());
        Logger.info("Java {0} {1} ({2})", Environment.jreVersion(), Environment.is64Bit() ? " 64-bit" : " 32-bit", Environment.jvmArch());
        Logger.info("JxBrowser version: {0}", VersionInfo.version());
        Logger.info("Chromium version: {0}", VersionInfo.chromiumVersion());
        Logger.info("Temp folder: {0}", Environment.userTempDir());
        if (Environment.isWindows()) {
            Logger.info("AppData folder: {0}", Environment.win32UserAppDataLocalDir());
        }
    }

    public static Optional<Path> win32UserAppDataLocalDir() {
        if (!Environment.isWindows()) {
            throw new IllegalStateException("Unsupported operating system");
        }
        String localAppDataEnv = System.getenv("LOCALAPPDATA");
        if (localAppDataEnv != null) {
            return Optional.of(Paths.get(localAppDataEnv, new String[0]));
        }
        return Optional.empty();
    }

    public static Path userTempDir() {
        return Environment.path("java.io.tmpdir");
    }

    public static Path userHomeDir() {
        return Environment.path("user.home");
    }

    private Environment() {
    }

    private static String property(String name) {
        return System.getProperty(name);
    }

    private static Path path(String propertyName) {
        return Paths.get(Environment.property(propertyName), new String[0]);
    }

    private static String osName() {
        return Environment.property("os.name");
    }

    private static String osVersion() {
        return Environment.property("os.version");
    }

    private static String jreVersion() {
        return Environment.property("java.version");
    }

    private static String jvmArch() {
        return Environment.property("os.arch");
    }

    private static boolean isOsSupported() {
        if (Environment.isWindows()) {
            return Version.parse(Environment.osVersion()).compareTo(MIN_WIN_VERSION) >= 0;
        }
        if (Environment.isMac()) {
            return Version.parse(Environment.osVersion()).compareTo(MIN_MAC_VERSION) >= 0;
        }
        return Environment.isLinux() && Environment.is64Bit();
    }

    private static boolean isJreSupported() {
        return Runtime.version().feature() >= 17;
    }
}

