/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.plugin.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.plugin.PluginSettings;
import com.teamdev.jxbrowser.plugin.internal.rpc.PluginSettingsStub;
import com.teamdev.jxbrowser.plugin.internal.rpc.SetPdfViewerEnabledRequest;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;

public final class PluginSettingsImpl
extends CloseableImpl
implements PluginSettings {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<PluginSettingsStub> rpc;

    PluginSettingsImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        EngineImpl engine = profile.engine();
        this.rpc = new ServiceConnectionImpl<PluginSettingsStub>(engine.id(), engine.connection(), PluginSettingsStub::new);
    }

    @Override
    public void enablePdfViewer() {
        this.setPdfViewerEnabled(true);
    }

    @Override
    public void disablePdfViewer() {
        this.setPdfViewerEnabled(false);
    }

    @Override
    public boolean isPdfViewerEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isPdfViewerEnabled, this.profile.id())).getValue();
    }

    private void setPdfViewerEnabled(boolean enabled) {
        this.checkNotClosed();
        SetPdfViewerEnabledRequest request = SetPdfViewerEnabledRequest.newBuilder().setEnabled(BoolValue.of(enabled)).setProfileId(this.profile.id()).build();
        this.rpc.invoke(this.rpc.stub()::setPdfViewerEnabled, request);
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }
}

