/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.profile.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.cache.internal.HttpAuthCacheImpl;
import com.teamdev.jxbrowser.cache.internal.HttpCacheImpl;
import com.teamdev.jxbrowser.card.CreditCards;
import com.teamdev.jxbrowser.card.internal.CreditCardsImpl;
import com.teamdev.jxbrowser.cast.internal.MediaCastingImpl;
import com.teamdev.jxbrowser.cookie.internal.CookieStoreImpl;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.download.internal.DownloadsImpl;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.extensions.internal.ExtensionsImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.ProfileId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.net.internal.NetworkImpl;
import com.teamdev.jxbrowser.net.proxy.internal.ProxyImpl;
import com.teamdev.jxbrowser.password.internal.PasswordStoreImpl;
import com.teamdev.jxbrowser.permission.internal.PermissionsImpl;
import com.teamdev.jxbrowser.plugin.internal.PluginsImpl;
import com.teamdev.jxbrowser.profile.Profile;
import com.teamdev.jxbrowser.profile.ProfilePreferences;
import com.teamdev.jxbrowser.profile.internal.ProfilePreferencesImpl;
import com.teamdev.jxbrowser.profile.internal.ProfilesImpl;
import com.teamdev.jxbrowser.profile.internal.rpc.BrowserOptions;
import com.teamdev.jxbrowser.profile.internal.rpc.ClearProfileDataRequest;
import com.teamdev.jxbrowser.profile.internal.rpc.ProfileStub;
import com.teamdev.jxbrowser.spellcheck.internal.SpellCheckerImpl;
import com.teamdev.jxbrowser.time.TimeRange;
import com.teamdev.jxbrowser.time.internal.rpc.Timestamp;
import com.teamdev.jxbrowser.user.UserDataProfiles;
import com.teamdev.jxbrowser.user.internal.UserDataProfilesImpl;
import com.teamdev.jxbrowser.zoom.internal.ZoomLevelsImpl;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ProfileImpl
extends CloseableImpl
implements Profile {
    private static final IdMap<ProfileId, ProfileImpl> allProfiles = new IdMap();
    private final ProfileId id;
    private final ProfilesImpl profiles;
    private final List<BrowserImpl> browsers;
    private final ServiceConnectionImpl<ProfileStub> rpc;
    private final Lazy<ProxyImpl> proxy;
    private final Lazy<PluginsImpl> plugins;
    private final Lazy<NetworkImpl> network;
    private final Lazy<DownloadsImpl> downloads;
    private final Lazy<HttpCacheImpl> httpCache;
    private final Lazy<ExtensionsImpl> extensions;
    private final Lazy<ZoomLevelsImpl> zoomLevels;
    private final Lazy<CookieStoreImpl> cookieStore;
    private final Lazy<PermissionsImpl> permissions;
    private final Lazy<SpellCheckerImpl> spellChecker;
    private final Lazy<HttpAuthCacheImpl> httpAuthCache;
    private final Lazy<PasswordStoreImpl> passwordStore;
    private final Lazy<ProfilePreferencesImpl> preferences;
    private final Lazy<CreditCardsImpl> creditCardStore;
    private final Lazy<UserDataProfilesImpl> userDataStore;
    private final MediaCastingImpl mediaCasting;

    public static ProfileImpl of(ProfileId id) {
        Preconditions.checkNotNull(id);
        return ProfileImpl.findImpl(id).orElseThrow(IllegalStateException::new);
    }

    public ProfileImpl(ProfilesImpl profiles, ProfileId id) {
        Preconditions.checkNotNull(profiles);
        Preconditions.checkNotNull(id);
        this.id = id;
        this.profiles = profiles;
        this.browsers = new CopyOnWriteArrayList<BrowserImpl>();
        this.proxy = new Lazy<ProxyImpl>(() -> new ProxyImpl(this));
        this.network = new Lazy<NetworkImpl>(() -> new NetworkImpl(this));
        this.plugins = new Lazy<PluginsImpl>(() -> new PluginsImpl(this));
        this.downloads = new Lazy<DownloadsImpl>(() -> new DownloadsImpl(this));
        this.httpCache = new Lazy<HttpCacheImpl>(() -> new HttpCacheImpl(this));
        this.extensions = new Lazy<ExtensionsImpl>(() -> new ExtensionsImpl(this));
        this.zoomLevels = new Lazy<ZoomLevelsImpl>(() -> new ZoomLevelsImpl(this));
        this.cookieStore = new Lazy<CookieStoreImpl>(() -> new CookieStoreImpl(this));
        this.permissions = new Lazy<PermissionsImpl>(() -> new PermissionsImpl(this));
        this.spellChecker = new Lazy<SpellCheckerImpl>(() -> new SpellCheckerImpl(this));
        this.httpAuthCache = new Lazy<HttpAuthCacheImpl>(() -> new HttpAuthCacheImpl(this));
        this.passwordStore = new Lazy<PasswordStoreImpl>(() -> new PasswordStoreImpl(this));
        this.preferences = new Lazy<ProfilePreferencesImpl>(() -> new ProfilePreferencesImpl(this));
        this.creditCardStore = new Lazy<CreditCardsImpl>(() -> new CreditCardsImpl(this));
        this.userDataStore = new Lazy<UserDataProfilesImpl>(() -> new UserDataProfilesImpl(this));
        this.mediaCasting = new MediaCastingImpl(this);
        EngineImpl engine = profiles.engine();
        this.rpc = new ServiceConnectionImpl<ProfileStub>(engine.id(), engine.connection(), ProfileStub::new);
        if (!engine.options().schemes().isEmpty()) {
            this.network().initialize();
        }
        allProfiles.put(id, this);
        profiles.register(this);
    }

    private static Optional<ProfileImpl> findImpl(ProfileId id) {
        Preconditions.checkNotNull(id);
        Logger.debug(() -> "Finding profile with id: " + id);
        return allProfiles.find(id);
    }

    public ProfileId id() {
        return this.id;
    }

    @Override
    public EngineImpl engine() {
        return this.profiles.engine();
    }

    @Override
    public Browser newBrowser() {
        this.checkNotClosed();
        BrowserOptions request = BrowserOptions.newBuilder().setEngineId(this.engine().id()).setProfileId(this.id()).build();
        BrowserId browserId = (BrowserId)this.rpc.invoke(this.rpc.stub()::createBrowser, request);
        BrowserImpl browser = new BrowserImpl(this.engine().connection(), this, browserId);
        browser.initializeMainFrame();
        return browser;
    }

    @Override
    public List<Browser> browsers() {
        return Collections.unmodifiableList(this.browsers);
    }

    public void register(BrowserImpl browser) {
        if (!this.browsers.contains(browser)) {
            this.browsers.add(browser);
        }
    }

    public void unregister(BrowserImpl browser) {
        this.browsers.remove(browser);
    }

    @Override
    public String path() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::path, this.id)).getValue();
    }

    @Override
    public boolean isIncognito() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isIncognito, this.id)).getValue();
    }

    @Override
    public boolean isDefault() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isDefault, this.id)).getValue();
    }

    @Override
    public String name() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::name, this.id)).getValue();
    }

    @Override
    public ZoomLevelsImpl zoomLevels() {
        return this.zoomLevels.get();
    }

    @Override
    public PluginsImpl plugins() {
        return this.plugins.get();
    }

    @Override
    public ProxyImpl proxy() {
        return this.proxy.get();
    }

    @Override
    public NetworkImpl network() {
        return this.network.get();
    }

    @Override
    public ExtensionsImpl extensions() {
        this.checkNotClosed();
        return this.extensions.get();
    }

    @Override
    public SpellCheckerImpl spellChecker() {
        return this.spellChecker.get();
    }

    @Override
    public CookieStoreImpl cookieStore() {
        return this.cookieStore.get();
    }

    @Override
    public PasswordStoreImpl passwordStore() {
        return this.passwordStore.get();
    }

    @Override
    public HttpCacheImpl httpCache() {
        return this.httpCache.get();
    }

    @Override
    public HttpAuthCacheImpl httpAuthCache() {
        return this.httpAuthCache.get();
    }

    @Override
    public DownloadsImpl downloads() {
        return this.downloads.get();
    }

    @Override
    public PermissionsImpl permissions() {
        return this.permissions.get();
    }

    @Override
    public ProfilePreferences preferences() {
        return this.preferences.get();
    }

    @Override
    public UserDataProfiles userDataProfiles() {
        return this.userDataStore.get();
    }

    @Override
    public CreditCards creditCards() {
        return this.creditCardStore.get();
    }

    @Override
    public MediaCastingImpl mediaCasting() {
        return this.mediaCasting;
    }

    public ClearProfileDataRequest clearProfileDataRequest(TimeRange timeRange) {
        Preconditions.checkNotNull(timeRange);
        return ClearProfileDataRequest.newBuilder().setId(this.id()).setFrom(Timestamp.cast(timeRange.start())).setTo(Timestamp.cast(timeRange.end())).build();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        ProfileImpl.closeIfNecessary(this.plugins);
        ProfileImpl.closeIfNecessary(this.proxy);
        ProfileImpl.closeIfNecessary(this.network);
        ProfileImpl.closeIfNecessary(this.spellChecker);
        ProfileImpl.closeIfNecessary(this.cookieStore);
        ProfileImpl.closeIfNecessary(this.httpCache);
        ProfileImpl.closeIfNecessary(this.httpAuthCache);
        ProfileImpl.closeIfNecessary(this.downloads);
        ProfileImpl.closeIfNecessary(this.permissions);
        ProfileImpl.closeIfNecessary(this.zoomLevels);
        ProfileImpl.closeIfNecessary(this.preferences);
        ProfileImpl.closeIfNecessary(this.passwordStore);
        ProfileImpl.closeIfNecessary(this.userDataStore);
        ProfileImpl.closeIfNecessary(this.creditCardStore);
        ProfileImpl.closeIfNecessary(this.extensions);
        this.mediaCasting.close();
        this.browsers.forEach(BrowserImpl::close);
        this.cleanup();
        super.close();
    }

    void cleanup() {
        this.rpc.close();
        this.browsers.forEach(BrowserImpl::cleanup);
        allProfiles.remove(this.id);
        this.profiles.unregister(this);
    }
}

