/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.browser.internal.rpc.CursorChanged;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.internal.BuiltInCursors;
import com.teamdev.jxbrowser.ui.internal.ToolkitCursors;
import com.teamdev.jxbrowser.ui.internal.rpc.Bitmap;
import com.teamdev.jxbrowser.ui.internal.rpc.Cursor;
import com.teamdev.jxbrowser.ui.internal.rpc.CursorType;
import com.teamdev.jxbrowser.ui.internal.rpc.CustomCursor;

public abstract class CursorFactory<C, T> {
    private final ToolkitCursors<T> toolkitCursors;

    protected CursorFactory(ToolkitCursors<T> toolkitCursors) {
        this.toolkitCursors = toolkitCursors;
    }

    public C newCursor(CursorChanged event) {
        CursorChanged.CursorCase cursorCase = event.getCursorCase();
        if (cursorCase == CursorChanged.CursorCase.STANDARD) {
            return this.standardCursor(event.getStandard());
        }
        if (cursorCase == CursorChanged.CursorCase.CUSTOM) {
            return this.customCursor(event.getCustom());
        }
        throw CursorFactory.noData(event);
    }

    private C standardCursor(Cursor data) {
        CursorType type = data.getType();
        return (C)this.toolkitCursors.get(type).map(this::toolkitCursor).orElse(BuiltInCursors.instance().find(type).map(this::builtInCursor).orElse(this.defaultCursor()));
    }

    protected abstract C toolkitCursor(T var1);

    protected abstract C builtInCursor(BuiltInCursors.BuiltInCursorData var1);

    private C customCursor(CustomCursor data) {
        Bitmap bitmap = data.getBitmap();
        if (!CursorFactory.hasValidSize(bitmap)) {
            return this.defaultCursor();
        }
        return this.customCursor(bitmap, data.getHotspot());
    }

    protected abstract C customCursor(com.teamdev.jxbrowser.ui.Bitmap var1, Point var2);

    protected abstract C defaultCursor();

    private static boolean hasValidSize(com.teamdev.jxbrowser.ui.Bitmap bitmap) {
        return bitmap.size().width() > 0 && bitmap.size().height() > 0;
    }

    private static IllegalArgumentException noData(CursorChanged event) {
        throw new IllegalArgumentException(String.format("The `CursorChanged` event `%s` contains no cursor data.", event));
    }
}

