/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.focus.FocusState;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.callback.TakeFocusCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.TakeFocus;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.dsl.ui.SizeKt;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.os.internal.OnScreenKeyboard;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.compose.internal.RenderWidgetState;
import com.teamdev.jxbrowser.view.compose.internal.render.AwtWindowKt;
import com.teamdev.jxbrowser.view.compose.internal.render.BoundsChangeListener;
import com.teamdev.jxbrowser.view.compose.internal.render.ScalingKt;
import com.teamdev.jxbrowser.view.compose.internal.render.WindowMovedListener;
import com.teamdev.jxbrowser.view.compose.internal.render.WindowOpenedListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001:\u0002;<B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020,J\u0016\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u00020,2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u00107\u001a\u00020,H\u0002J\b\u00108\u001a\u00020,H\u0002J\b\u00109\u001a\u00020,H\u0002J\b\u0010:\u001a\u00020,H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R/\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006="}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/WindowedWidgetState;", "Lcom/teamdev/jxbrowser/view/compose/internal/RenderWidgetState;", "widget", "Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "window", "Ljava/awt/Window;", "<init>", "(Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;Lkotlinx/coroutines/CoroutineScope;Ljava/awt/Window;)V", "displayId", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "boundsListener", "Lcom/teamdev/jxbrowser/view/compose/internal/render/BoundsChangeListener;", "onWindowMoved", "Lcom/teamdev/jxbrowser/view/compose/internal/render/WindowMovedListener;", "onWindowOpened", "Lcom/teamdev/jxbrowser/view/compose/internal/render/WindowOpenedListener;", "onWindowIconified", "Lcom/teamdev/jxbrowser/view/compose/internal/WindowedWidgetState$WindowIconifiedListener;", "onScreenKeyboard", "Lcom/teamdev/jxbrowser/os/internal/OnScreenKeyboard;", "globalFocusListenerWin", "Ljava/awt/event/AWTEventListener;", "focusGained", "Lcom/teamdev/jxbrowser/event/Subscription;", "isShown", "", "focusRequester", "Landroidx/compose/ui/focus/FocusRequester;", "getFocusRequester", "()Landroidx/compose/ui/focus/FocusRequester;", "<set-?>", "Landroidx/compose/ui/focus/FocusDirection;", "focusDirection", "getFocusDirection-6Ue6xsY", "()Landroidx/compose/ui/focus/FocusDirection;", "setFocusDirection-RvHMakY", "(Landroidx/compose/ui/focus/FocusDirection;)V", "focusDirection$delegate", "Landroidx/compose/runtime/MutableState;", "show", "", "hide", "onPositioned", "coords", "Landroidx/compose/ui/layout/LayoutCoordinates;", "density", "Landroidx/compose/ui/unit/Density;", "onFocusChanged", "focusState", "Landroidx/compose/ui/focus/FocusState;", "updateDisplayIdIfChanged", "attach", "onAttached", "onAttachFailed", "close", "GlobalFocusListenerWin", "WindowIconifiedListener", "compose"})
@Stable
@SourceDebugExtension(value={"SMAP\nWindowedWidgetState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowedWidgetState.kt\ncom/teamdev/jxbrowser/view/compose/internal/WindowedWidgetState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 Async.kt\ncom/teamdev/jxbrowser/dsl/AsyncKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n81#2:311\n107#2,2:312\n78#3:314\n44#3:315\n61#3:316\n1#4:317\n*S KotlinDebug\n*F\n+ 1 WindowedWidgetState.kt\ncom/teamdev/jxbrowser/view/compose/internal/WindowedWidgetState\n*L\n126#1:311\n126#1:312,2\n143#1:314\n150#1:315\n173#1:316\n*E\n"})
public final class WindowedWidgetState
implements RenderWidgetState {
    @NotNull
    private final BrowserWidget widget;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Window window;
    private String displayId;
    @NotNull
    private final BoundsChangeListener boundsListener;
    @NotNull
    private final WindowMovedListener onWindowMoved;
    @NotNull
    private final WindowOpenedListener onWindowOpened;
    @NotNull
    private final WindowIconifiedListener onWindowIconified;
    @NotNull
    private final OnScreenKeyboard onScreenKeyboard;
    @Nullable
    private final AWTEventListener globalFocusListenerWin;
    private Subscription focusGained;
    private boolean isShown;
    @NotNull
    private final FocusRequester focusRequester;
    @NotNull
    private final MutableState focusDirection$delegate;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public WindowedWidgetState(@NotNull BrowserWidget widget, @NotNull CoroutineScope scope, @NotNull Window window) {
        AWTEventListener aWTEventListener;
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.widget = widget;
        this.scope = scope;
        this.window = window;
        this.displayId = Display.primaryDisplay().id();
        this.boundsListener = new BoundsChangeListener(this.widget);
        this.onWindowMoved = new WindowMovedListener((Function1<? super IntOffset, Unit>)((Function1)new Function1<IntOffset, Unit>((Object)this.boundsListener){

            public final void invoke--gyyYBs(long p0) {
                ((BoundsChangeListener)this.receiver).onWindowPositioned--gyyYBs(p0);
            }
        }));
        this.onWindowOpened = new WindowOpenedListener((Function1<? super IntOffset, Unit>)((Function1)new Function1<IntOffset, Unit>((Object)this.boundsListener){

            public final void invoke--gyyYBs(long p0) {
                ((BoundsChangeListener)this.receiver).onWindowPositioned--gyyYBs(p0);
            }
        }));
        this.onWindowIconified = new WindowIconifiedListener();
        this.onScreenKeyboard = new OnScreenKeyboard(this.widget.browser());
        WindowedWidgetState windowedWidgetState = this;
        if (Environment.isWindows()) {
            void $this$globalFocusListenerWin_u24lambda_u240;
            GlobalFocusListenerWin globalFocusListenerWin;
            GlobalFocusListenerWin globalFocusListenerWin2 = globalFocusListenerWin = new GlobalFocusListenerWin();
            WindowedWidgetState windowedWidgetState2 = windowedWidgetState;
            boolean bl = false;
            Toolkit.getDefaultToolkit().addAWTEventListener((AWTEventListener)$this$globalFocusListenerWin_u24lambda_u240, 524288L);
            windowedWidgetState = windowedWidgetState2;
            aWTEventListener = globalFocusListenerWin;
        } else {
            aWTEventListener = null;
        }
        windowedWidgetState.globalFocusListenerWin = aWTEventListener;
        this.focusRequester = new FocusRequester();
        this.focusDirection$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
    }

    @NotNull
    public final FocusRequester getFocusRequester() {
        return this.focusRequester;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FocusDirection getFocusDirection-6Ue6xsY() {
        void $this$getValue$iv;
        State state = (State)this.focusDirection$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (FocusDirection)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setFocusDirection-RvHMakY(@Nullable FocusDirection focusDirection) {
        void $this$setValue$iv;
        MutableState mutableState = this.focusDirection$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)focusDirection);
    }

    /*
     * WARNING - void declaration
     */
    public final void show() {
        void $this$register$iv;
        Advisable $this$subscribe$iv;
        Window window;
        if (this.isShown) {
            return;
        }
        Window $this$show_u24lambda_u241 = window = this.window;
        boolean bl = false;
        $this$show_u24lambda_u241.addWindowListener(this.onWindowOpened);
        $this$show_u24lambda_u241.addWindowListener(this.onWindowIconified);
        $this$show_u24lambda_u241.addComponentListener(this.onWindowMoved);
        Window $this$show_u24lambda_u244 = window = this.widget;
        boolean bl2 = false;
        BrowserImpl browserImpl = $this$show_u24lambda_u244.browser();
        Intrinsics.checkNotNullExpressionValue((Object)browserImpl, (String)"browser(...)");
        Observable observable = (Observable)browserImpl;
        Observer observer$iv = arg_0 -> WindowedWidgetState.show$lambda$4$lambda$2(this, arg_0);
        boolean $i$f$subscribe = false;
        Subscription subscription = $this$subscribe$iv.on(FocusGained.class, observer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)subscription, (String)"on(...)");
        this.focusGained = subscription;
        $this$subscribe$iv = (Advisable)$this$show_u24lambda_u244;
        Callback callback$iv = (Callback)((TakeFocusCallback)arg_0 -> WindowedWidgetState.show$lambda$4$lambda$3(this, arg_0));
        boolean $i$f$register = false;
        $this$register$iv.set(TakeFocusCallback.class, callback$iv);
        this.attach();
        this.onScreenKeyboard.addNativeListeners(AwtWindowKt.getNativeId(this.window));
        this.isShown = true;
    }

    public final void hide() {
        if (!this.isShown) {
            return;
        }
        Subscription subscription = this.focusGained;
        if (subscription == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"focusGained");
            subscription = null;
        }
        subscription.unsubscribe();
        Object object = this.widget;
        BrowserWidget $this$hide_u24lambda_u245 = object;
        boolean bl = false;
        Advisable $this$removeCallback$iv = (Advisable)$this$hide_u24lambda_u245;
        boolean $i$f$removeCallback = false;
        $this$removeCallback$iv.remove(TakeFocusCallback.class);
        $this$hide_u24lambda_u245.hide();
        Object $this$hide_u24lambda_u246 = object = this.window;
        boolean bl2 = false;
        ((Window)$this$hide_u24lambda_u246).removeWindowListener(this.onWindowOpened);
        ((Window)$this$hide_u24lambda_u246).removeWindowListener(this.onWindowIconified);
        ((Component)$this$hide_u24lambda_u246).removeComponentListener(this.onWindowMoved);
        this.onScreenKeyboard.removeNativeListeners(AwtWindowKt.getNativeId(this.window));
        this.isShown = false;
    }

    public final void onPositioned(@NotNull LayoutCoordinates coords, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        if (!Environment.isLinux()) {
            this.updateDisplayIdIfChanged(AwtWindowKt.getDisplayId(this.window));
        }
        this.boundsListener.onPositionedInLayout-15RKIV8(ScalingKt.scaledSize(coords, density), ScalingKt.scaledPositionInWindow(coords, density), AwtWindowKt.getPosition(this.window));
    }

    public final void onFocusChanged(@NotNull FocusState focusState) {
        Intrinsics.checkNotNullParameter((Object)focusState, (String)"focusState");
        if (focusState.isFocused()) {
            this.widget.focus();
        } else {
            this.widget.unfocus();
        }
    }

    private final void updateDisplayIdIfChanged(String displayId) {
        if (Intrinsics.areEqual((Object)this.displayId, (Object)displayId)) {
            return;
        }
        this.widget.displayId(displayId);
        this.boundsListener.updateWidgetBounds();
        this.displayId = displayId;
    }

    /*
     * WARNING - void declaration
     */
    private final void attach() {
        void $this$attach_u24lambda_u247;
        long l = this.boundsListener.getSize-YbymL2g();
        Runnable runnable = this::onAttachFailed;
        Runnable runnable2 = this::onAttached;
        long l2 = AwtWindowKt.getNativeId(this.window);
        BrowserWidget browserWidget = this.widget;
        boolean bl = false;
        Size size = SizeKt.Size((int)IntSize.getWidth-impl((long)$this$attach_u24lambda_u247), (int)IntSize.getHeight-impl((long)$this$attach_u24lambda_u247));
        browserWidget.attach(l2, runnable2, runnable, size);
    }

    private final void onAttached() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ WindowedWidgetState this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (WindowedWidgetState.access$isShown$p(this.this$0)) {
                            WindowedWidgetState.access$getWidget$p(this.this$0).show();
                            WindowedWidgetState.access$getBoundsListener$p(this.this$0).updateWidgetBounds();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void onAttachFailed() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ WindowedWidgetState this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.close();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void close() {
        AWTEventListener aWTEventListener = this.globalFocusListenerWin;
        if (aWTEventListener != null) {
            AWTEventListener aWTEventListener2 = aWTEventListener;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            AWTEventListener p0 = aWTEventListener2;
            boolean bl = false;
            toolkit.removeAWTEventListener(p0);
        }
        this.hide();
    }

    private static final void show$lambda$4$lambda$2(WindowedWidgetState this$0, FocusGained it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ WindowedWidgetState this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (WindowedWidgetState.access$isShown$p(this.this$0)) {
                            this.this$0.getFocusRequester().requestFocus();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final TakeFocus.Response show$lambda$4$lambda$3(WindowedWidgetState this$0, TakeFocus.Request params) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, params, null){
            int label;
            final /* synthetic */ WindowedWidgetState this$0;
            final /* synthetic */ TakeFocus.Request $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.setFocusDirection-RvHMakY(FocusDirection.box-impl((int)(this.$params.getFocusNextComponent() ? FocusDirection.Companion.getNext-dhqQ-8s() : FocusDirection.Companion.getPrevious-dhqQ-8s())));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return TakeFocus.Response.newBuilder().setTake(Protobuf.empty()).build();
    }

    public static final /* synthetic */ BoundsChangeListener access$getBoundsListener$p(WindowedWidgetState $this) {
        return $this.boundsListener;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/WindowedWidgetState$GlobalFocusListenerWin;", "Ljava/awt/event/AWTEventListener;", "<init>", "(Lcom/teamdev/jxbrowser/view/compose/internal/WindowedWidgetState;)V", "eventDispatched", "", "event", "Ljava/awt/AWTEvent;", "compose"})
    private final class GlobalFocusListenerWin
    implements AWTEventListener {
        @Override
        public void eventDispatched(@NotNull AWTEvent event) {
            boolean isFocusLost;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            boolean bl = isFocusLost = event.getID() == 208;
            if (Intrinsics.areEqual((Object)event.getSource(), (Object)WindowedWidgetState.this.window) && isFocusLost) {
                WindowedWidgetState.this.widget.unfocus();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/WindowedWidgetState$WindowIconifiedListener;", "Ljava/awt/event/WindowAdapter;", "<init>", "(Lcom/teamdev/jxbrowser/view/compose/internal/WindowedWidgetState;)V", "wasShownAtMinimize", "", "windowIconified", "", "e", "Ljava/awt/event/WindowEvent;", "windowDeiconified", "restore", "minimize", "compose"})
    private final class WindowIconifiedListener
    extends WindowAdapter {
        private boolean wasShownAtMinimize;

        @Override
        public void windowIconified(@NotNull WindowEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.wasShownAtMinimize = WindowedWidgetState.this.isShown;
            if (this.wasShownAtMinimize) {
                this.minimize();
            }
        }

        @Override
        public void windowDeiconified(@NotNull WindowEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.wasShownAtMinimize) {
                this.restore();
            }
        }

        public final void restore() {
            if (Environment.isLinux()) {
                WindowedWidgetState.this.attach();
            }
            WindowedWidgetState.this.widget.restore();
        }

        public final void minimize() {
            if (Environment.isLinux()) {
                WindowedWidgetState.this.widget.hide();
            }
            WindowedWidgetState.this.widget.minimize();
        }
    }
}

