/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.dnd;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.draganddrop.DragAndDropEvent;
import androidx.compose.ui.draganddrop.DragAndDropTarget;
import androidx.compose.ui.unit.IntOffset;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.DragCursorUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers;
import com.teamdev.jxbrowser.view.compose.internal.dnd.ChromiumDropTargetKt;
import com.teamdev.jxbrowser.view.compose.internal.dnd.CustomDataType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.DragAndDropContext;
import com.teamdev.jxbrowser.view.compose.internal.dnd.FileListDataType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.HtmlDataType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.TextDataType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.UrlDataType;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u001d\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\"\u001a\u0016\u0012\b\u0012\u00060%j\u0002`$\u0012\b\u0012\u00060%j\u0002`$0#*\u00020&H\u0002J \u0010\"\u001a\u0016\u0012\b\u0012\u00060%j\u0002`$\u0012\b\u0012\u00060%j\u0002`$0#*\u00020'H\u0002J$\u0010(\u001a\u0016\u0012\b\u0012\u00060%j\u0002`$\u0012\b\u0012\u00060%j\u0002`$0#2\u0006\u0010)\u001a\u00020*H\u0002J\f\u0010+\u001a\u00020\u0016*\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumDropTarget;", "Landroidx/compose/ui/draganddrop/DragAndDropTarget;", "widget", "Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;", "context", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DragAndDropContext;", "externalDragEnabled", "", "<init>", "(Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DragAndDropContext;Z)V", "operation", "Lcom/teamdev/jxbrowser/browser/internal/rpc/DragOperation;", "dragCursorUpdated", "Lcom/teamdev/jxbrowser/event/Subscription;", "componentPosition", "Landroidx/compose/ui/unit/IntOffset;", "J", "windowPosition", "dataTypes", "", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DataType;", "start", "", "stop", "onPositionChanged", "positionInRoot", "onPositionChanged-E1MhUcY", "(JJ)V", "onDrop", "event", "Landroidx/compose/ui/draganddrop/DragAndDropEvent;", "onEntered", "onMoved", "onExited", "location", "Lkotlin/Pair;", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/ProtoPoint;", "Lcom/teamdev/jxbrowser/ui/Point;", "Ljava/awt/dnd/DropTargetDragEvent;", "Ljava/awt/dnd/DropTargetDropEvent;", "calculateLocation", "awtPoint", "Ljava/awt/Point;", "acceptOrRejectDrag", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChromiumDropTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromiumDropTarget.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumDropTarget\n+ 2 Async.kt\ncom/teamdev/jxbrowser/dsl/AsyncKt\n*L\n1#1,275:1\n78#2:276\n*S KotlinDebug\n*F\n+ 1 ChromiumDropTarget.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumDropTarget\n*L\n88#1:276\n*E\n"})
public final class ChromiumDropTarget
implements DragAndDropTarget {
    @NotNull
    private final BrowserWidget widget;
    @NotNull
    private final DragAndDropContext context;
    private final boolean externalDragEnabled;
    @NotNull
    private DragOperation operation;
    @Nullable
    private Subscription dragCursorUpdated;
    private long componentPosition;
    private long windowPosition;
    @NotNull
    private final List<DataType> dataTypes;
    public static final int $stable = 8;

    public ChromiumDropTarget(@NotNull BrowserWidget widget, @NotNull DragAndDropContext context, boolean externalDragEnabled) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.widget = widget;
        this.context = context;
        this.externalDragEnabled = externalDragEnabled;
        this.operation = DragOperation.OPERATION_NONE;
        this.componentPosition = IntOffset.Companion.getZero-nOcc-ac();
        this.windowPosition = IntOffset.Companion.getZero-nOcc-ac();
        Object[] objectArray = new DataType[]{new UrlDataType(), new HtmlDataType(), new TextDataType(), new CustomDataType(), new FileListDataType()};
        this.dataTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void start() {
        void $this$subscribe$iv;
        Observable observable = (Observable)this.widget;
        Observer observer$iv = arg_0 -> ChromiumDropTarget.start$lambda$0(this, arg_0);
        boolean $i$f$subscribe = false;
        Subscription subscription = $this$subscribe$iv.on(DragCursorUpdated.class, observer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)subscription, (String)"on(...)");
        this.dragCursorUpdated = subscription;
    }

    public final void stop() {
        block0: {
            Subscription subscription = this.dragCursorUpdated;
            if (subscription == null) break block0;
            subscription.unsubscribe();
        }
    }

    public final void onPositionChanged-E1MhUcY(long positionInRoot, long windowPosition) {
        this.componentPosition = positionInRoot;
        this.windowPosition = windowPosition;
    }

    public boolean onDrop(@NotNull DragAndDropEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getNativeEvent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.dnd.DropTargetDropEvent");
        DropTargetDropEvent awtEvent = (DropTargetDropEvent)object;
        Pair<Point, Point> pair = this.location(awtEvent);
        Point localPoint = (Point)pair.component1();
        Point screenPoint = (Point)pair.component2();
        Transferable transferable = awtEvent.getTransferable();
        Intrinsics.checkNotNullExpressionValue((Object)transferable, (String)"getTransferable(...)");
        DropData dropData = ChromiumDropTargetKt.access$fillDropData(transferable, this.dataTypes);
        KeyModifiers keyModifiers = ChromiumDropTargetKt.access$keyModifiers(awtEvent);
        this.widget.drop(dropData, localPoint, screenPoint, keyModifiers);
        return true;
    }

    public void onEntered(@NotNull DragAndDropEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.context.getDragAction() == null && !this.externalDragEnabled) {
            return;
        }
        Object object = event.getNativeEvent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.dnd.DropTargetDragEvent");
        DropTargetDragEvent awtEvent = (DropTargetDragEvent)object;
        Transferable transferable = awtEvent.getTransferable();
        Intrinsics.checkNotNull((Object)transferable);
        if (!ChromiumDropTargetKt.access$isSupported(transferable, this.dataTypes)) {
            awtEvent.rejectDrag();
            return;
        }
        DropMetadata metadata = ChromiumDropTargetKt.access$fillMetadata(transferable, this.dataTypes);
        Pair<Point, Point> pair = this.location(awtEvent);
        Point localPoint = (Point)pair.component1();
        Point screenPoint = (Point)pair.component2();
        int operationsAllowed = ChromiumDropTargetKt.access$dragOperationMask(awtEvent);
        KeyModifiers keyModifiers = ChromiumDropTargetKt.access$keyModifiers(awtEvent);
        this.widget.dragEnter(metadata, localPoint, screenPoint, operationsAllowed, keyModifiers);
    }

    public void onMoved(@NotNull DragAndDropEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getNativeEvent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.dnd.DropTargetDragEvent");
        DropTargetDragEvent awtEvent = (DropTargetDragEvent)object;
        Transferable transferable = awtEvent.getTransferable();
        Intrinsics.checkNotNull((Object)transferable);
        if (!ChromiumDropTargetKt.access$isSupported(transferable, this.dataTypes)) {
            awtEvent.rejectDrag();
            return;
        }
        this.acceptOrRejectDrag(awtEvent);
        Pair<Point, Point> pair = this.location(awtEvent);
        Point localPoint = (Point)pair.component1();
        Point screenPoint = (Point)pair.component2();
        int operationsAllowed = ChromiumDropTargetKt.access$dragOperationMask(awtEvent);
        KeyModifiers keyModifiers = ChromiumDropTargetKt.access$keyModifiers(awtEvent);
        this.widget.dragOver(localPoint, screenPoint, operationsAllowed, keyModifiers);
    }

    public void onExited(@NotNull DragAndDropEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.widget.dragLeave();
    }

    private final Pair<Point, Point> location(DropTargetDragEvent $this$location) {
        java.awt.Point point = $this$location.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
        return this.calculateLocation(point);
    }

    private final Pair<Point, Point> location(DropTargetDropEvent $this$location) {
        java.awt.Point point = $this$location.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
        return this.calculateLocation(point);
    }

    private final Pair<Point, Point> calculateLocation(java.awt.Point awtPoint) {
        Point localPoint = Point.of((int)(awtPoint.x - IntOffset.getX-impl((long)this.componentPosition)), (int)(awtPoint.y - IntOffset.getY-impl((long)this.componentPosition)));
        Point screenPoint = Point.of((int)(awtPoint.x + IntOffset.getX-impl((long)this.windowPosition)), (int)(awtPoint.y + IntOffset.getX-impl((long)this.windowPosition)));
        return new Pair((Object)localPoint, (Object)screenPoint);
    }

    private final void acceptOrRejectDrag(DropTargetDragEvent $this$acceptOrRejectDrag) {
        if (this.operation == DragOperation.OPERATION_NONE) {
            $this$acceptOrRejectDrag.rejectDrag();
        } else {
            $this$acceptOrRejectDrag.acceptDrag(ChromiumDropTargetKt.access$toAwtOperation(this.operation));
        }
    }

    private static final void start$lambda$0(ChromiumDropTarget this$0, DragCursorUpdated it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.operation = it.getDragOperation();
    }
}

