/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.dnd;

import androidx.compose.runtime.internal.StabilityInferred;
import com.teamdev.jxbrowser.internal.MacPasteboard;
import com.teamdev.jxbrowser.os.Environment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/MacOsCompatibility;", "", "<init>", "()V", "SERIALIZED_URL_FLAVOR", "Ljava/awt/datatransfer/DataFlavor;", "getSERIALIZED_URL_FLAVOR", "()Ljava/awt/datatransfer/DataFlavor;", "configureFlavorMap", "", "readUrlFromPasteboard", "", "serializeUrlForPasteboard", "", "url", "compose"})
@StabilityInferred(parameters=0)
public final class MacOsCompatibility {
    @NotNull
    public static final MacOsCompatibility INSTANCE = new MacOsCompatibility();
    @NotNull
    private static final DataFlavor SERIALIZED_URL_FLAVOR = new DataFlavor(byte[].class, "Serialized URL");
    public static final int $stable = 8;

    private MacOsCompatibility() {
    }

    @NotNull
    public final DataFlavor getSERIALIZED_URL_FLAVOR() {
        return SERIALIZED_URL_FLAVOR;
    }

    public final void configureFlavorMap() {
        if (!Environment.isMac()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
        Intrinsics.checkNotNull((Object)flavorMap, (String)"null cannot be cast to non-null type java.awt.datatransfer.SystemFlavorMap");
        SystemFlavorMap flavorMap2 = (SystemFlavorMap)flavorMap;
        String[] stringArray = new String[]{"URL"};
        flavorMap2.setNativesForFlavor(SERIALIZED_URL_FLAVOR, stringArray);
    }

    @Nullable
    public final String readUrlFromPasteboard() {
        if (!Environment.isMac()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return MacPasteboard.instance().readUrl();
    }

    @NotNull
    public final byte[] serializeUrlForPasteboard(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!Environment.isMac()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        byte[] byArray = MacPasteboard.instance().serializeUrl(url);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serializeUrl(...)");
        return byArray;
    }
}

