/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.io;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.input.pointer.PointerIcon;
import androidx.compose.ui.input.pointer.PointerIcon_desktopKt;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.BuiltInCursors;
import com.teamdev.jxbrowser.ui.internal.CursorFactory;
import com.teamdev.jxbrowser.ui.internal.ToolkitCursors;
import com.teamdev.jxbrowser.ui.internal.rpc.CursorType;
import com.teamdev.jxbrowser.view.compose.graphics.BitmapImageKt;
import com.teamdev.jxbrowser.view.compose.internal.io.ComposeCursorFactoryKt;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001dB\t\b\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0002H\u0014J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\u001d\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/io/ComposeCursorFactory;", "Lcom/teamdev/jxbrowser/ui/internal/CursorFactory;", "Landroidx/compose/ui/input/pointer/PointerIcon;", "", "<init>", "()V", "defaultCursor", "toolkitCursor", "cursorType", "builtInCursor", "data", "Lcom/teamdev/jxbrowser/ui/internal/BuiltInCursors$BuiltInCursorData;", "customCursor", "bitmap", "Lcom/teamdev/jxbrowser/ui/Bitmap;", "hotspot", "Lcom/teamdev/jxbrowser/ui/Point;", "cursorFromImage", "Ljava/awt/Cursor;", "image", "Ljava/awt/Image;", "name", "", "bestCursorSize", "Ljava/awt/Dimension;", "kotlin.jvm.PlatformType", "size", "Lcom/teamdev/jxbrowser/ui/Size;", "(Lcom/teamdev/jxbrowser/ui/Size;)Ljava/awt/Dimension;", "StandardCursors", "compose"})
@StabilityInferred(parameters=1)
public final class ComposeCursorFactory
extends CursorFactory<PointerIcon, Integer> {
    public static final int $stable;

    public ComposeCursorFactory() {
        super(StandardCursors.INSTANCE.getCursors());
    }

    @NotNull
    protected PointerIcon defaultCursor() {
        return PointerIcon.Companion.getDefault();
    }

    @NotNull
    protected PointerIcon toolkitCursor(int cursorType) {
        Cursor cursor = Cursor.getPredefinedCursor(cursorType);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
        return PointerIcon_desktopKt.PointerIcon((Cursor)cursor);
    }

    @NotNull
    protected PointerIcon builtInCursor(@NotNull BuiltInCursors.BuiltInCursorData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BuiltInCursors.BuiltInCursorData $this$builtInCursor_u24lambda_u240 = data;
        boolean bl = false;
        Image image = Toolkit.getDefaultToolkit().getImage($this$builtInCursor_u24lambda_u240.resource());
        Intrinsics.checkNotNull((Object)image);
        Point point = $this$builtInCursor_u24lambda_u240.hotspot();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"hotspot(...)");
        Cursor awtCursor = this.cursorFromImage(image, point, $this$builtInCursor_u24lambda_u240.type().name());
        return PointerIcon_desktopKt.PointerIcon((Cursor)awtCursor);
    }

    @NotNull
    protected PointerIcon customCursor(@NotNull Bitmap bitmap, @NotNull Point hotspot) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)hotspot, (String)"hotspot");
        Size size = bitmap.size();
        Intrinsics.checkNotNullExpressionValue((Object)size, (String)"size(...)");
        Dimension cursorSize = this.bestCursorSize(size);
        if (cursorSize.width == 0 && cursorSize.height == 0) {
            return this.defaultCursor();
        }
        BufferedImage bufferedImage = BitmapImageKt.toBufferedImage(bitmap);
        Intrinsics.checkNotNull((Object)cursorSize);
        BufferedImage image = ComposeCursorFactoryKt.access$resized(bufferedImage, cursorSize);
        Cursor awtCursor = ComposeCursorFactory.cursorFromImage$default(this, image, hotspot, null, 4, null);
        return PointerIcon_desktopKt.PointerIcon((Cursor)awtCursor);
    }

    private final Cursor cursorFromImage(Image image, Point hotspot, String name) {
        java.awt.Point awtHotspot = new java.awt.Point(hotspot.x(), hotspot.y());
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, awtHotspot, name);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"createCustomCursor(...)");
        return cursor;
    }

    static /* synthetic */ Cursor cursorFromImage$default(ComposeCursorFactory composeCursorFactory, Image image, Point point, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "customCursor";
        }
        return composeCursorFactory.cursorFromImage(image, point, string);
    }

    private final Dimension bestCursorSize(Size size) {
        return Toolkit.getDefaultToolkit().getBestCursorSize(size.width(), size.height());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/io/ComposeCursorFactory$StandardCursors;", "", "<init>", "()V", "cursors", "Lcom/teamdev/jxbrowser/ui/internal/ToolkitCursors;", "", "getCursors", "()Lcom/teamdev/jxbrowser/ui/internal/ToolkitCursors;", "setCursors", "(Lcom/teamdev/jxbrowser/ui/internal/ToolkitCursors;)V", "createCursors", "compose"})
    private static final class StandardCursors {
        @NotNull
        public static final StandardCursors INSTANCE = new StandardCursors();
        @NotNull
        private static ToolkitCursors<Integer> cursors = INSTANCE.createCursors();

        private StandardCursors() {
        }

        @NotNull
        public final ToolkitCursors<Integer> getCursors() {
            return cursors;
        }

        public final void setCursors(@NotNull ToolkitCursors<Integer> toolkitCursors) {
            Intrinsics.checkNotNullParameter(toolkitCursors, (String)"<set-?>");
            cursors = toolkitCursors;
        }

        private final ToolkitCursors<Integer> createCursors() {
            ToolkitCursors.Builder builder = ToolkitCursors.newBuilder().add(CursorType.POINTER, (Object)0).add(CursorType.CROSS, (Object)1).add(CursorType.HAND, (Object)12).add(CursorType.WAIT, (Object)3).add(CursorType.I_BEAM, (Object)2).add(CursorType.NORTH_RESIZE, (Object)8).add(CursorType.EAST_RESIZE, (Object)11).add(CursorType.SOUTH_RESIZE, (Object)9).add(CursorType.WEST_RESIZE, (Object)10).add(CursorType.NORTH_EAST_RESIZE, (Object)7).add(CursorType.SOUTH_EAST_RESIZE, (Object)5).add(CursorType.NORTH_WEST_RESIZE, (Object)6).add(CursorType.SOUTH_WEST_RESIZE, (Object)4).add(CursorType.NORTH_SOUTH_RESIZE, (Object)8).add(CursorType.EAST_WEST_RESIZE, (Object)11).add(CursorType.NORTH_EAST_SOUTH_WEST_RESIZE, (Object)7).add(CursorType.NORTH_WEST_SOUTH_EAST_RESIZE, (Object)6);
            if (!Environment.isMac()) {
                builder.add(CursorType.MOVE, (Object)13);
            }
            ToolkitCursors toolkitCursors = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)toolkitCursors, (String)"build(...)");
            return toolkitCursors;
        }
    }
}

