/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.StartDrag;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.internal.rpc.Bitmap;
import com.teamdev.jxbrowser.ui.internal.rpc.Size;
import com.teamdev.jxbrowser.view.swing.graphics.BitmapImage;
import com.teamdev.jxbrowser.view.swing.internal.ToolkitConverters;
import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;

final class DragImage {
    private static final Image EMPTY_IMAGE = DragImage.emptyImage();
    private final Image image;
    private final java.awt.Point imageOffset;

    static DragImage createImage(StartDrag.Request params) {
        java.awt.Point imageOffset = ToolkitConverters.toPoint((Point)params.getDragImageOffset());
        Bitmap dragImageBitmap = params.getDragImage();
        Bitmap dragImage1xBitmap = params.getDragImage1X();
        if (!dragImageBitmap.size().isEmpty() && !dragImage1xBitmap.size().isEmpty()) {
            BufferedImage image = BitmapImage.toToolkit((com.teamdev.jxbrowser.ui.Bitmap)dragImageBitmap);
            BufferedImage image1x = BitmapImage.toToolkit((com.teamdev.jxbrowser.ui.Bitmap)dragImage1xBitmap);
            BaseMultiResolutionImage dragImage = new BaseMultiResolutionImage(image1x, image);
            if (Environment.isMac()) {
                imageOffset.x = -imageOffset.x;
                imageOffset.y = -imageOffset.y;
            }
            return new DragImage(dragImage, imageOffset);
        }
        return new DragImage(EMPTY_IMAGE, imageOffset);
    }

    private DragImage(Image image, java.awt.Point imageOffset) {
        this.image = image;
        this.imageOffset = imageOffset;
    }

    Image toToolkit() {
        return this.image;
    }

    java.awt.Point offset() {
        return this.imageOffset;
    }

    private static BufferedImage emptyImage() {
        Size oneByOnePixel = Size.newBuilder().setWidth(1).setHeight(1).build();
        ByteString singlePixel = ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0});
        Bitmap bitmap = Bitmap.newBuilder().setSize(oneByOnePixel).setPixels(singlePixel).build();
        return BitmapImage.toToolkit((com.teamdev.jxbrowser.ui.Bitmap)bitmap);
    }
}

