/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.view.swing.internal.dnd.MimeType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.RichDataFlavor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

final class ListDataFlavor<T>
extends RichDataFlavor<List<T>> {
    static <T> ListDataFlavor<T> newInstance(String mimeType) {
        return new ListDataFlavor<T>(MimeType.newInstance(mimeType));
    }

    private ListDataFlavor(MimeType mimeType) {
        super(mimeType);
    }

    @Override
    List<T> read(Transferable transferable) {
        try {
            Optional<DataFlavor> flavor = Arrays.stream(transferable.getTransferDataFlavors()).filter(this.mimeType::matches).findFirst();
            if (flavor.isPresent()) {
                List list = (List)transferable.getTransferData(flavor.get());
                return list;
            }
            throw this.noSuitableFlavor();
        }
        catch (UnsupportedFlavorException | IOException | ClassCastException e) {
            throw new IllegalStateException(e);
        }
    }
}

