/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.view.javafx.BrowserView;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;

public final class AncestorsVisibilityTracker {
    private final VisibilityListener visibilityListener;
    private final HierarchyListener hierarchyListener;
    private final BrowserView browserView;
    private final List<Parent> discoveredParents;

    public static Builder newBuilder() {
        return new Builder();
    }

    private AncestorsVisibilityTracker(Builder builder) {
        this.browserView = builder.browserView;
        this.visibilityListener = new VisibilityListener(builder.onShow, builder.onHide);
        this.hierarchyListener = new HierarchyListener();
        this.discoveredParents = new ArrayList<Parent>();
    }

    public void attach() {
        this.browserView.parentProperty().addListener((ChangeListener)this.hierarchyListener);
        this.browserView.visibleProperty().addListener((ChangeListener)this.visibilityListener);
    }

    public void detach() {
        this.browserView.parentProperty().removeListener((ChangeListener)this.hierarchyListener);
        this.browserView.visibleProperty().removeListener((ChangeListener)this.visibilityListener);
        this.discoveredParents.forEach(parent -> {
            parent.parentProperty().removeListener((ChangeListener)this.hierarchyListener);
            parent.visibleProperty().removeListener((ChangeListener)this.visibilityListener);
        });
    }

    private static Collection<Parent> findAncestorsFor(Parent node) {
        ArrayDeque<Parent> ancestors = new ArrayDeque<Parent>();
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            ancestors.add(parent);
        }
        return ancestors;
    }

    private void updateListenersFor(Collection<Parent> nodes) {
        nodes.stream().map(Node::parentProperty).forEach(parentProperty -> {
            parentProperty.removeListener((ChangeListener)this.hierarchyListener);
            parentProperty.addListener((ChangeListener)this.hierarchyListener);
        });
        nodes.stream().map(Node::visibleProperty).forEach(visibleProperty -> {
            visibleProperty.removeListener((ChangeListener)this.visibilityListener);
            visibleProperty.addListener((ChangeListener)this.visibilityListener);
        });
        this.discoveredParents.addAll(nodes);
    }

    private void removeListenersFor(Collection<Parent> nodes) {
        nodes.stream().map(Node::parentProperty).forEach(parentProperty -> parentProperty.removeListener((ChangeListener)this.hierarchyListener));
        nodes.stream().map(Node::visibleProperty).forEach(visibleProperty -> visibleProperty.removeListener((ChangeListener)this.visibilityListener));
    }

    public static class Builder {
        private BrowserView browserView;
        private Runnable onShow;
        private Runnable onHide;

        public Builder browserView(BrowserView node) {
            this.browserView = node;
            return this;
        }

        public Builder onShow(Runnable onShow) {
            this.onShow = onShow;
            return this;
        }

        public Builder onHide(Runnable onHide) {
            this.onHide = onHide;
            return this;
        }

        public AncestorsVisibilityTracker build() {
            return new AncestorsVisibilityTracker(this);
        }
    }

    private static class VisibilityListener
    implements ChangeListener<Boolean> {
        private final Runnable onShow;
        private final Runnable onHide;

        VisibilityListener(Runnable onShow, Runnable onHide) {
            this.onShow = onShow;
            this.onHide = onHide;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            Platform.runLater(() -> {
                if (newValue.booleanValue()) {
                    this.onShow.run();
                } else {
                    this.onHide.run();
                }
            });
        }
    }

    private class HierarchyListener
    implements ChangeListener<Parent> {
        private HierarchyListener() {
        }

        public void changed(ObservableValue<? extends Parent> observable, Parent oldValue, Parent newValue) {
            Collection<Parent> ancestors;
            if (oldValue != null) {
                oldValue.visibleProperty().removeListener((ChangeListener)AncestorsVisibilityTracker.this.visibilityListener);
                oldValue.parentProperty().removeListener((ChangeListener)this);
                ancestors = AncestorsVisibilityTracker.findAncestorsFor(oldValue);
                AncestorsVisibilityTracker.this.removeListenersFor(ancestors);
            }
            if (newValue != null) {
                newValue.visibleProperty().addListener((ChangeListener)AncestorsVisibilityTracker.this.visibilityListener);
                newValue.parentProperty().addListener((ChangeListener)this);
                ancestors = AncestorsVisibilityTracker.findAncestorsFor(newValue);
                AncestorsVisibilityTracker.this.updateListenersFor(ancestors);
            }
        }
    }
}

