/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

final class ClosestParentTab {
    private ClosestParentTab() {
    }

    static Optional<Tab> ofNode(Node node) {
        Optional<Tab> tab;
        Optional<TabPane> pane = ClosestParentTab.findTabPane(node.getParent());
        if (pane.isPresent() && (tab = ClosestParentTab.find(pane.get(), node)).isPresent()) {
            return tab;
        }
        return Optional.empty();
    }

    private static Optional<Tab> find(TabPane pane, Node node) {
        for (Tab tab : pane.getTabs()) {
            Node tabContent = tab.getContent();
            if (!ClosestParentTab.contains(tabContent, node)) continue;
            return Optional.of(tab);
        }
        return Optional.empty();
    }

    private static Optional<TabPane> findTabPane(Parent parent) {
        Parent result = parent;
        while (result != null) {
            if (result instanceof TabPane) {
                return Optional.of((TabPane)result);
            }
            result = result.getParent();
        }
        return Optional.empty();
    }

    private static boolean contains(Node parent, Node child) {
        if (child.equals(parent)) {
            return true;
        }
        for (Parent p = child.getParent(); p != null; p = p.getParent()) {
            if (!p.equals(parent)) continue;
            return true;
        }
        return false;
    }
}

