/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.view.javafx.internal.ClosestParentTab;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;

public final class NodeVisibility {
    public static boolean isVisibleOnScene(Node node) {
        if (NodeVisibility.isTreeInvisible(node)) {
            return false;
        }
        return !NodeVisibility.isInHiddenTab(node);
    }

    private NodeVisibility() {
    }

    static boolean isNotVisible(Node node) {
        if (NodeVisibility.isWindowHidden(node)) {
            return true;
        }
        return !NodeVisibility.isVisibleOnScene(node);
    }

    private static boolean isWindowHidden(Node node) {
        Scene scene = node.getScene();
        if (scene != null) {
            Window window = scene.getWindow();
            return window == null || !window.isShowing();
        }
        return true;
    }

    private static boolean isTreeInvisible(Node node) {
        for (Node parent = node; parent != null; parent = parent.getParent()) {
            if (parent.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean isInHiddenTab(Node node) {
        return ClosestParentTab.ofNode(node).map(t -> !t.isSelected()).orElse(false);
    }
}

