/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.common.base.Splitter;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.internal.MacPasteboard;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.internal.CustomDataMimeType;
import com.teamdev.jxbrowser.view.internal.CustomTypeMimeType;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;

final class Clipboard {
    private static final DataFormat PLACEHOLDER;
    private static final DataFormat CUSTOM_DATA;
    private static final DataFormat CUSTOM_TYPES;
    private static final String PLACEHOLDER_DATA = "application/x-board-should-not-be-empty";
    private static final String UNRECOGNIZED_DATA = "application/x-custom-data-unrecognized";
    private static final String ABOUT_BLANK_BLOCKED = "about:blank#blocked";
    private final Dragboard dragboard;

    private Clipboard(Dragboard dragboard) {
        this.dragboard = dragboard;
    }

    static Clipboard of(Dragboard dragboard) {
        return new Clipboard(dragboard);
    }

    DropMetadata dropMetadata() {
        DropMetadata.Builder builder = DropMetadata.newBuilder();
        builder.setContainsUrl(this.hasUrl(this.dragboard));
        builder.setContainsText(this.dragboard.hasString());
        builder.setContainsHtml(this.dragboard.hasHtml());
        builder.setContainsFiles(this.dragboard.hasFiles());
        if (this.dragboard.hasContent(CUSTOM_TYPES)) {
            String[] types;
            for (String type : types = (String[])this.dragboard.getContent(CUSTOM_TYPES)) {
                builder.addCustomDataTypes(type);
            }
        } else if (this.dragboard.hasContent(CUSTOM_DATA)) {
            builder.addCustomDataTypes(UNRECOGNIZED_DATA);
        }
        return builder.build();
    }

    DropData dropData() {
        Object content;
        byte[] data;
        DropData.Builder builder = DropData.newBuilder();
        if (this.hasUrl(this.dragboard)) {
            builder.setUrl(this.getUrl(this.dragboard));
            builder.setText(this.dragboard.getUrl());
        }
        if (this.dragboard.hasString()) {
            String text = this.dragboard.getString();
            builder.setText(text);
        }
        if (this.dragboard.hasHtml()) {
            builder.setHtml(this.dragboard.getHtml());
        }
        if (this.dragboard.hasFiles()) {
            List files = this.dragboard.getFiles();
            for (File file : files) {
                builder.addFile(com.teamdev.jxbrowser.net.internal.rpc.File.newBuilder().setFilePath(file.getAbsolutePath()).build());
            }
        }
        if (Environment.isMac() && (data = MacPasteboard.instance().readCustomData()).length > 0) {
            DropData.CustomData customData = this.customData(ByteString.copyFrom((byte[])data));
            builder.setCustomData(customData);
        }
        if (this.dragboard.hasContent(CUSTOM_DATA) && (content = this.dragboard.getContent(CUSTOM_DATA)) instanceof ByteBuffer) {
            ByteBuffer data2 = (ByteBuffer)content;
            DropData.CustomData customData = this.customData(ByteString.copyFrom((ByteBuffer)data2));
            builder.setCustomData(customData);
        }
        return builder.build();
    }

    void setContent(DropData data) {
        ByteString customData;
        HashMap<DataFormat, Object> content = new HashMap<DataFormat, Object>();
        if (!data.getUrl().isEmpty()) {
            content.put(DataFormat.URL, data.getUrl());
            content.put(DataFormat.PLAIN_TEXT, data.getUrl());
        }
        if (!data.getText().isEmpty()) {
            content.put(DataFormat.PLAIN_TEXT, data.getText());
        }
        if (!this.shouldIgnoreBaseUrl(data.getHtmlBaseUrl()) || !data.getHtml().isEmpty()) {
            content.put(DataFormat.HTML, data.getHtml());
        }
        if (!(customData = data.getCustomData().getAsBytes()).isEmpty()) {
            content.put(CUSTOM_DATA, ByteBuffer.wrap(customData.toByteArray()));
            String[] types = (String[])data.getCustomData().getTypesList().toArray((Object[])new String[0]);
            content.put(CUSTOM_TYPES, types);
        }
        if (content.isEmpty()) {
            content.put(PLACEHOLDER, "");
        }
        this.dragboard.setContent(content);
    }

    private boolean shouldIgnoreBaseUrl(String baseUrl) {
        return baseUrl.isEmpty() || baseUrl.equals(ABOUT_BLANK_BLOCKED);
    }

    private DropData.CustomData customData(ByteString data) {
        return DropData.CustomData.newBuilder().setAsBytes(data).build();
    }

    private boolean hasUrl(Dragboard dragboard) {
        if (Environment.isLinux()) {
            for (DataFormat contentType : dragboard.getContentTypes()) {
                if (!contentType.equals((Object)this.netscapeUrlDataFormat())) continue;
                return true;
            }
        }
        return dragboard.hasUrl();
    }

    private String getUrl(Dragboard dragboard) {
        Object content;
        DataFormat netscapeUrlType;
        if (Environment.isLinux() && (netscapeUrlType = this.netscapeUrlDataFormat()) != null && (content = dragboard.getContent(netscapeUrlType)) instanceof ByteBuffer) {
            String dropData = StandardCharsets.UTF_8.decode((ByteBuffer)content).toString();
            List chunks = Splitter.onPattern((String)"\\s").splitToList((CharSequence)dropData);
            if (!chunks.isEmpty()) {
                return (String)chunks.get(0);
            }
        }
        return dragboard.getUrl();
    }

    private DataFormat netscapeUrlDataFormat() {
        return DataFormat.lookupMimeType((String)"_NETSCAPE_URL");
    }

    static {
        CustomDataMimeType nativeDragFormat = CustomDataMimeType.forCurrentPlatform();
        CUSTOM_DATA = new DataFormat(new String[]{nativeDragFormat.value()});
        CUSTOM_TYPES = new DataFormat(new String[]{CustomTypeMimeType.value()});
        PLACEHOLDER = new DataFormat(new String[]{PLACEHOLDER_DATA});
    }
}

