/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.BuiltInCursors;
import com.teamdev.jxbrowser.view.javafx.internal.graphics.CursorImage;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.BuiltInCursors;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.image.Image;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class CursorFactory
extends com.teamdev.jxbrowser.ui.internal.CursorFactory<Cursor, Cursor> {
    CursorFactory() {
        super(BuiltInCursors.instance());
    }

    protected Cursor toolkitCursor(Cursor cursor) {
        return cursor;
    }

    protected Cursor builtInCursor(BuiltInCursors.BuiltInCursorData data) {
        Image image = new Image(data.resource().toString());
        return CursorFactory.cursorFromImage(image, data.hotspot());
    }

    protected Cursor customCursor(Bitmap bitmap, Point hotspot) {
        if (this.customCursorForbiddenByOs(bitmap.size())) {
            return this.defaultCursor();
        }
        Image cursorImage = CursorImage.toToolkit(bitmap);
        return CursorFactory.cursorFromImage(cursorImage, hotspot);
    }

    protected Cursor defaultCursor() {
        return Cursor.DEFAULT;
    }

    private boolean customCursorForbiddenByOs(Size cursorSize) {
        Dimension2D bestCursorSize = ImageCursor.getBestSize((double)cursorSize.width(), (double)cursorSize.width());
        return (int)bestCursorSize.getWidth() == 0 && (int)bestCursorSize.getHeight() == 0;
    }

    private static Cursor cursorFromImage(Image image, Point cursorHotspot) {
        Point2D hotspot = new Point2D((double)cursorHotspot.x(), (double)cursorHotspot.y());
        return new ImageCursor(image, hotspot.getX(), hotspot.getY());
    }
}

