/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.CursorChanged;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.CursorFactory;
import javafx.application.Platform;
import javafx.scene.Cursor;
import javafx.scene.Node;

final class CursorListener
implements Observer<CursorChanged> {
    private final BrowserWidget browserWidget;
    private final CursorFactory cursorFactory;
    private Node node;
    private Subscription subscription;

    CursorListener(BrowserWidget browserWidget) {
        this.browserWidget = browserWidget;
        this.cursorFactory = new CursorFactory();
    }

    public void on(CursorChanged event) {
        Platform.runLater(() -> {
            if (this.node != null) {
                this.node.getParent().setCursor((Cursor)this.cursorFactory.newCursor(event));
            }
        });
    }

    void attach(Node node) {
        this.node = node;
        this.subscription = this.browserWidget.on(CursorChanged.class, (Observer)this);
    }

    void detach() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
        this.node = null;
    }
}

