/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.view.javafx.internal.FocusTraversal;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.InputMethods;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.KeyboardBridge;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

final class KeyListener
implements EventHandler<KeyEvent> {
    private static final List<KeyCode> NOT_TRAVERSIBLES = ImmutableList.of((Object)KeyCode.TAB, (Object)KeyCode.UP, (Object)KeyCode.DOWN, (Object)KeyCode.LEFT, (Object)KeyCode.RIGHT);
    private final KeyboardBridge keyboardBridge;
    private Node node;

    KeyListener(InputMethods ime, BrowserWidget widget) {
        this.keyboardBridge = KeyboardBridge.newInstance(widget, ime);
    }

    public void handle(KeyEvent event) {
        if (FocusTraversal.isTraversalEvent(event)) {
            return;
        }
        this.suppressTraversalKeys(event);
        this.keyboardBridge.forward(event);
    }

    private void suppressTraversalKeys(KeyEvent event) {
        KeyCode keyCode = event.getCode();
        if (NOT_TRAVERSIBLES.contains(keyCode)) {
            event.consume();
        }
    }

    void attach(Node node) {
        this.node = node;
        this.node.addEventHandler(KeyEvent.ANY, (EventHandler)this);
    }

    void detach() {
        if (this.node != null) {
            this.node.removeEventHandler(KeyEvent.ANY, (EventHandler)this);
        }
        this.node = null;
    }
}

