/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.ScrollType;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import java.util.function.Function;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.ScrollEvent;

final class ScrollListener
implements EventHandler<ScrollEvent> {
    private final BrowserWidget widget;
    private final Function<Point, Point> jfxPanelAdjustment;
    private Node node;

    private ScrollListener(BrowserWidget widget, Function<Point, Point> jfxPanelAdjustment) {
        this.widget = widget;
        this.jfxPanelAdjustment = jfxPanelAdjustment;
    }

    static Builder newBuilder(BrowserWidget widget) {
        return new Builder(widget);
    }

    public void handle(ScrollEvent event) {
        double deltaX = event.getDeltaX();
        double deltaY = event.getDeltaY();
        if (event.getTextDeltaXUnits() != ScrollEvent.HorizontalTextScrollUnits.NONE) {
            deltaX *= Math.abs(event.getTextDeltaX());
            deltaY *= Math.abs(event.getTextDeltaY());
        }
        MouseWheel mouseWheel = MouseWheel.newBuilder((Point)this.localPointOf(event)).locationOnScreen(Point.of((int)((int)event.getScreenX()), (int)((int)event.getScreenY()))).deltaX((float)deltaX).deltaY((float)deltaY).scrollType(ScrollType.UNIT_SCROLL).keyModifiers(this.keyModifiers(event)).build();
        this.widget.dispatch(mouseWheel);
    }

    private KeyModifiers keyModifiers(ScrollEvent event) {
        return KeyModifiers.newBuilder().altDown(event.isAltDown()).shiftDown(event.isShiftDown()).controlDown(event.isControlDown()).metaDown(event.isMetaDown()).build();
    }

    private Point localPointOf(ScrollEvent event) {
        Point point = Point.of((int)((int)event.getX()), (int)((int)event.getY()));
        Point adjusted = this.jfxPanelAdjustment.apply(point);
        return adjusted;
    }

    void attach(Node node) {
        this.node = node;
        this.node.addEventHandler(ScrollEvent.ANY, (EventHandler)this);
    }

    void detach() {
        if (this.node != null) {
            this.node.removeEventHandler(ScrollEvent.ANY, (EventHandler)this);
        }
        this.node = null;
    }

    static final class Builder {
        private final BrowserWidget widget;
        private Function<Point, Point> jfxPanelAdjustment;

        private Builder(BrowserWidget widget) {
            this.widget = widget;
        }

        Builder jfxPanelAdjustment(Function<Point, Point> jfxPanelAdjustment) {
            this.jfxPanelAdjustment = jfxPanelAdjustment;
            return this;
        }

        ScrollListener build() {
            return new ScrollListener(this.widget, this.jfxPanelAdjustment);
        }
    }
}

