/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.swt.internal.SwtAutoScaleProperty;
import org.eclipse.swt.graphics.Rectangle;

final class DpiAwareRectangle {
    private final Rectangle original;
    private final double systemScaleFactor;
    private Double scaleFactor;

    DpiAwareRectangle(Rectangle original, double systemScaleFactor) {
        this.original = (Rectangle)Preconditions.checkNotNull((Object)original);
        this.systemScaleFactor = systemScaleFactor;
    }

    int x() {
        return this.scale(this.original.x);
    }

    int y() {
        return this.scale(this.original.y);
    }

    int width() {
        return this.scale(this.original.width);
    }

    int height() {
        return this.scale(this.original.height);
    }

    private int scale(int original) {
        return (int)Math.round((double)original * this.scaleFactor());
    }

    private Double scaleFactor() {
        if (this.scaleFactor == null) {
            double swtScaleFactor = SwtAutoScaleProperty.doubleValue().orElseGet(() -> {
                if (SwtAutoScaleProperty.isQuarter()) {
                    return (double)Math.round(this.systemScaleFactor * 4.0) / 4.0;
                }
                if (SwtAutoScaleProperty.isInteger()) {
                    return Math.round(this.systemScaleFactor - Math.ulp(this.systemScaleFactor));
                }
                if (SwtAutoScaleProperty.isExact()) {
                    return this.systemScaleFactor;
                }
                return 1.0;
            });
            this.scaleFactor = swtScaleFactor / this.systemScaleFactor;
        }
        return this.scaleFactor;
    }
}

