/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.view.swt.internal.BrowserComposite;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

final class FirstAppearanceDetector
extends ShellAdapter
implements PaintListener {
    private final BrowserComposite browserComposite;
    private Shell shell;

    FirstAppearanceDetector(BrowserComposite browserComposite) {
        this.browserComposite = browserComposite;
    }

    void startEventProcessing() {
        this.browserComposite.addPaintListener(this);
        this.shell = this.browserComposite.getShell();
        if (this.shell != null) {
            this.shell.addShellListener((ShellListener)this);
        }
    }

    void stopEventProcessing() {
        this.browserComposite.removePaintListener(this);
        this.browserComposite.getShell().removeShellListener((ShellListener)this);
    }

    public void paintControl(PaintEvent paintEvent) {
        this.stopEventProcessing();
        SafeExecutor.asyncExec((Widget)this.browserComposite, this.browserComposite::showRenderWidget);
    }

    public void shellActivated(ShellEvent shellEvent) {
        if (!this.browserComposite.isDisposed() && this.browserComposite.isVisible() && this.shell == this.browserComposite.getShell()) {
            this.stopEventProcessing();
            this.browserComposite.showRenderWidget();
        } else if (this.browserComposite.isDisposed() && !this.shell.isDisposed()) {
            this.shell.removeShellListener((ShellListener)this);
        }
    }
}

