/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.rpc.MemoryId;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.swt.internal.SafeExecutor;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

final class MemoryImage {
    private final PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
    private int width;
    private int height;
    private int[] pixels;
    private double deviceScaleFactor = 1.0;
    private Image image;
    private ImageData imageData;
    private MemoryId memoryId;

    MemoryImage() {
        this.initialize(Size.of((int)1, (int)1));
    }

    double deviceScaleFactor() {
        return this.deviceScaleFactor;
    }

    Optional<Image> image() {
        return Optional.ofNullable(this.image);
    }

    Optional<MemoryId> memoryId() {
        return Optional.ofNullable(this.memoryId);
    }

    void updateMemoryId(MemoryId memoryId) {
        this.memoryId = memoryId;
    }

    int width() {
        return this.width;
    }

    int height() {
        return this.height;
    }

    void updateSize(Size viewSize, double scaleFactor) {
        boolean viewResized;
        this.deviceScaleFactor = scaleFactor;
        int viewWidth = viewSize.width();
        int viewHeight = viewSize.height();
        boolean bl = viewResized = this.width != viewWidth || this.height != viewHeight;
        if (viewResized) {
            this.initialize(viewSize);
        }
    }

    private void initialize(Size size) {
        this.width = size.width();
        this.height = size.height();
        this.pixels = new int[this.width * this.height];
    }

    void updatePixels(Rect dirtyRect) {
        ToolkitLibrary.instance().updatePixelInts(this.memoryId.getValue(), dirtyRect, Size.of((int)this.width, (int)this.height), this.pixels);
    }

    void repaintImage(Composite composite, Size viewSize, Rect dirtyRect, Consumer<Rect> repaintCallback) {
        SafeExecutor.asyncExec((Widget)composite, () -> {
            Composite composite2 = composite;
            synchronized (composite2) {
                int viewWidth = viewSize.width();
                int viewHeight = viewSize.height();
                if (this.width != viewWidth || this.height != viewHeight) {
                    this.imageData = new ImageData(viewWidth, viewHeight, 32, this.palette);
                    return;
                }
                if (this.imageData == null || this.imageData.width != viewWidth || this.imageData.height != viewHeight) {
                    this.imageData = new ImageData(viewWidth, viewHeight, 32, this.palette);
                }
                int x = dirtyRect.origin().x();
                int y = dirtyRect.origin().y();
                int width = dirtyRect.size().width();
                int height = dirtyRect.size().height();
                for (int i = y; i < y + height; ++i) {
                    this.imageData.setPixels(x, i, width, this.pixels, i * viewWidth + x);
                }
                if (this.image != null) {
                    this.image.dispose();
                }
                this.image = new Image((Device)composite.getDisplay(), this.imageData);
            }
            repaintCallback.accept(dirtyRect);
        });
    }
}

