/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.internal.BuiltInCursors;
import com.teamdev.jxbrowser.ui.internal.CursorFactory;
import com.teamdev.jxbrowser.view.swt.graphics.BitmapImage;
import com.teamdev.jxbrowser.view.swt.internal.BuiltInCursors;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Resource;

@ParametersAreNonnullByDefault
final class SwtCursorFactory
extends CursorFactory<Cursor, Integer> {
    private final Device device;
    private final List<Cursor> cursors;

    private SwtCursorFactory(Device device) {
        super(BuiltInCursors.instance());
        this.device = device;
        this.cursors = new ArrayList<Cursor>();
    }

    static SwtCursorFactory forDevice(Device device) {
        Preconditions.checkNotNull((Object)device);
        return new SwtCursorFactory(device);
    }

    protected Cursor toolkitCursor(Integer cursorStyle) {
        Cursor cursor = new Cursor(this.device, cursorStyle.intValue());
        this.cursors.add(cursor);
        return cursor;
    }

    protected Cursor builtInCursor(BuiltInCursors.BuiltInCursorData data) {
        ImageData imageData = new ImageData(data.resourceAsStream());
        Point hotspot = data.hotspot();
        return this.createCursor(hotspot, imageData);
    }

    protected Cursor customCursor(Bitmap bitmap, Point hotspot) {
        Image cursorImage = BitmapImage.toToolkit(this.device, bitmap);
        return this.createCursor(hotspot, cursorImage.getImageData());
    }

    private Cursor createCursor(Point hotspot, ImageData imageData) {
        Cursor cursor = new Cursor(this.device, imageData, hotspot.x(), hotspot.y());
        this.cursors.add(cursor);
        return cursor;
    }

    protected Cursor defaultCursor() {
        return this.toolkitCursor(0);
    }

    void disposeCursors() {
        this.cursors.forEach(Resource::dispose);
    }
}

