/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.view.swt.internal.dnd.DataType;
import java.io.File;
import java.util.List;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;

final class FileListDataType
extends DataType<FileTransfer, List<com.teamdev.jxbrowser.net.internal.rpc.File>> {
    FileListDataType() {
        super(FileTransfer.getInstance());
    }

    @Override
    void fillDropData(TransferData transferData, DropData.Builder dropData) {
        if (!this.isPresentedIn(transferData)) {
            return;
        }
        String[] files = (String[])((FileTransfer)this.transfer()).nativeToJava(transferData);
        if (files != null) {
            for (String filePath : files) {
                File file = new File(filePath);
                dropData.addFile(this.toProtoFile(file));
            }
        }
    }

    @Override
    protected void fillMetadata(DropMetadata.Builder metadata) {
        metadata.setContainsFiles(true);
    }

    @Override
    List<com.teamdev.jxbrowser.net.internal.rpc.File> read(DropData dropData) {
        return dropData.getFileList();
    }

    @Override
    boolean isPresentedIn(DropData dropData) {
        return !dropData.getFileList().isEmpty();
    }

    private com.teamdev.jxbrowser.net.internal.rpc.File toProtoFile(File file) {
        return com.teamdev.jxbrowser.net.internal.rpc.File.newBuilder().setFilePath(file.getAbsolutePath()).build();
    }
}

