/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.platform;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.reflect.Methods;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swt.internal.platform.GtkLibraryV3;
import com.teamdev.jxbrowser.view.swt.internal.platform.GtkVersion;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class GtkLibrary {
    private static volatile GtkLibrary library;
    private final ToolkitLibrary toolkitLibrary = ToolkitLibrary.instance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GtkLibrary instance() {
        Preconditions.checkState((boolean)Environment.isLinux(), (Object)"GtkLibrary should be used only in Linux.");
        if (library != null) return library;
        Class<GtkLibrary> clazz = GtkLibrary.class;
        synchronized (GtkLibrary.class) {
            if (library != null) return library;
            GtkVersion version = GtkVersion.detect();
            if (version != GtkVersion.GTK_3) throw GtkLibrary.unsupportedGtkVersion(version);
            library = new GtkLibraryV3();
            // ** MonitorExit[var0] (shouldn't be in output)
            return library;
        }
    }

    GtkLibrary() {
    }

    public abstract long xWindow(Shell var1);

    public abstract long xDisplay(Shell var1);

    public abstract long socketHandle(Composite var1);

    public void focusWindow(Shell shell) {
        this.toolkitLibrary.focusWindow(this.xWindow(shell), this.xDisplay(shell));
    }

    public void embedToSocket(Composite embeddedComposite, long chromiumXWindow) {
        long socketHandle = this.socketHandle(embeddedComposite);
        this.toolkitLibrary.embedToSocket(socketHandle, chromiumXWindow);
    }

    final Method methodIn(Class<?> clazz, String methodName) {
        return (Method)Methods.findPublicMethodByName(clazz, (String)methodName).orElseThrow(IllegalStateException::new);
    }

    long get(Method method, long argument) {
        return (Long)Methods.invokeStatic((Method)method, (Object[])new Object[]{argument});
    }

    private static RuntimeException unsupportedGtkVersion(GtkVersion version) {
        String unsupportedVersion = String.format("Unsupported version of GTK: %s (SWT version: %s).", new Object[]{version, SWT.getVersion()});
        return new IllegalStateException(unsupportedVersion);
    }
}

