/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swt.internal.platform;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.reflect.Fields;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swt.internal.platform.GtkLibrary;
import com.teamdev.jxbrowser.view.swt.internal.platform.WindowIdAlgorithm;
import java.lang.reflect.Field;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

final class XWindowId
implements WindowIdAlgorithm {
    XWindowId() {
    }

    @Override
    public long findWindowId(Control control) {
        Preconditions.checkState((boolean)Environment.isLinux());
        if (control instanceof Shell) {
            return this.shellHandle((Shell)control);
        }
        if (control instanceof Composite) {
            return this.embeddedHandle(control);
        }
        throw new IllegalStateException("Failed to find SWT control X Window handle");
    }

    private long shellHandle(Shell shell) {
        return GtkLibrary.instance().xWindow(shell);
    }

    private long embeddedHandle(Control control) {
        Field field = Fields.declaredField(Composite.class, (String)"embeddedHandle");
        return (Long)Fields.value((Object)control, (Field)field);
    }
}

