# Checking out and building Platinum for Windows

## Environment and tools

Install `depot_tools` and Visual Studio. Please refer to the
[Chromium docs][windows-build-instructions] for the installation instructions.

### JDK

Download and install Oracle JDK 21 (64-bit). If you need to support a 32-bit JRE, also download and install
JDK 8 (32-bit). OpenJDK distributions should work as well, but they have not been tested.

#### Environment variables

Create the following environment variables:

```cmd
JDK8_x86=C:\Program Files (x86)\Java\jdk-1.8\
JDK21_x64=C:\Program Files\Java\jdk-21\
```

Make sure the paths match your actual JDK installation directories.

### Directory structure

Platinum is used on the source code level by JxBrowser and DotNetBrowser. It is recommended to use
the following directory structure:

```
Projects\
  Chromium\
    142\
      Platinum\
      JxBrowser\
      DotNetBrowser\
```

Using this directory structure will allow you to run build scripts smoothly, without specifying
custom paths here and there.

The instructions below assume that the `Platinum` directory above is current.

### Terminal

Use Command Prompt (cmd.exe). It’s the only terminal guaranteed to work with the Chromium build infrastructure.

Building from PowerShell, Cygwin, or other non-cmd shells can lead to incorrect tool installation and subtle build errors.

## Checking out the code

### Chromium

```cmd
mkdir chromium
cd chromium
fetch --nohooks chromium
```

If you plan to build the official build with all optimizations enabled,
you should add the `"checkout_pgo_profiles": True` field to
the `custom_vars` dictionary in the `.gclient` config. So that the resulting
file would look like this:

```
solutions = [
  {
    # ...
    "custom_vars": {
      "checkout_pgo_profiles": True,
    },
  },
]
```

```cmd
cd src
git fetch --tags
git checkout 142.0.7444.60
gclient sync --with_branch_heads --with_tags -D
```

### Platinum

We install our code under `chromium\src` in a subdirectory called `browsercore`.
Stay in `chromium\src` directory and run:

```cmd
git clone git@github.com:TeamDev-IP/Platinum.git browsercore
cd browsercore
git checkout 142
```

If you are not a TeamDev employee, then just copy the `browsercore` directory located in the
archive with the source code or in the relink package to `chromium\src`.

## Building

Chromium supports both Windows 32-bit and 64-bit. The binaries for 64-bit architecture are
preferable. For each architecture you must build separate binaries.

In the `chromium\src\browsercore` directory, run the following script to apply patches to
the Chromium sources:

```cmd
cd tools
python3 patch_chromium.py
```

Stay in `tools` and run:

```cmd
python3 generate_project.py --official
```

This will produce a project with the same settings that are used in official JxBrowser builds.

By default, the target cpu architecture corresponds to the current host architecture. If you want
to build binaries for another architecture, specify the `target_cpu` option explicitly. For example,
to produce 32-bit binaries on a 64-bit host:

```cmd
python3 generate_project.py --official --target_cpu=x86
```

Are you a TeamDev employee? See additional [build steps][build-internal].

Build the project:

```cmd
cd ..\..\
autoninja -C out\Release chrome
```

### Output files

When the build is finished, the `out\Release` directory will contain lots of files. You don't
need them all. In order to extract the required ones, use the `publish_binaries.py` script:

```cmd
cd browsercore\tools
python3 publish_binaries.py
```

The binaries will be copied to the `browsercore\target\bin` directory.

### Binaries for JxBrowser

If you plan to build a JxBrowser distribution, compress the binaries into a single archive:

```cmd
python3 7zr.py
```

The archive and the corresponding `*.info` file will be created in `browsercore\target` directory.

By default, the name of the resulting archive will match the OS and CPU architecture of
the current host. If you want to compress binaries for other platforms, specify the `target_cpu`
and `target_os` options explicitly:

```cmd
python3 7zr.py --target_cpu=x86 --target_os=win
```

Lastly, create the `chromium.version` file that is required for JxBrowser build.

```bash
python3 generate_chromium_version.py
```

The file will be created in `browsercore\target` directory.

[windows-build-instructions]: https://chromium.googlesource.com/chromium/src/+/142.0.7444.60/docs/windows_build_instructions.md

[build-internal]: build_instructions_internal.md
