# Checking out and building Platinum for Mac

## Environment and tools

Install `depot_tools` and Xcode. Please refer to the
[Chromium docs][mac_build_instructions.md] for the installation instructions.

### JDK

Download and install Oracle JDK. You will need JDK 21 (64-bit) to build for Intel-based Macs, and JDK 21 (ARM64)
for Apple Silicon Macs. OpenJDK distributions should work as well, but they have not been tested.

### Environment variables

Add the following environment variables to your `~/.zshrc` file:

```bash
# macOS x86_64 (Intel)
export JDK21_x64=/Library/Java/JavaVirtualMachines/jdk-21-x64/Contents/Home

# macOS ARM64 (Apple Silicon)
export JDK21_ARM64=/Library/Java/JavaVirtualMachines/jdk-21-aarch64/Contents/Home
```

Make sure the paths match your actual JDK installation directories.

### Directory structure

Platinum is used on the source code level by JxBrowser and DotNetBrowser. It is recommended to use
the following directory structure:

```
Projects/
  Chromium/
    142/
      Platinum/
      JxBrowser/
      DotNetBrowser/
```

Using this directory structure will allow you to run build scripts smoothly, without specifying
custom paths here and there.

The instructions below assume that the `Platinum` directory above is current.

## Check out the code

### Chromium

```bash
mkdir chromium
cd chromium
fetch --nohooks chromium
```

If you plan to build the official build with all optimizations enabled,
you should add the `"checkout_pgo_profiles": True` field to
the `custom_vars` dictionary in the `.gclient` config. So that the resulting
file would look like this:

```
solutions = [
  {
    # ...
    "custom_vars": {
      "checkout_pgo_profiles": True,
    },
  },
]
```

```bash
cd src
git fetch --tags
git checkout 142.0.7444.176
gclient sync --with_branch_heads --with_tags -D
```

### Platinum

We install our code under `chromium/src` in a subdirectory called `browsercore`.
Stay in `chromium/src` directory and run:

```bash
git clone git@github.com:TeamDev-IP/Platinum.git browsercore
cd browsercore
git checkout 142
```

If you are not a TeamDev employee, then just copy the `browsercore` directory located in the
archive with the source code or in the relink package to `chromium/src`.

## Building

Make sure you are in the `browsercore` directory and run the following script to apply patches
to the Chromium sources:

```bash
cd tools
python3 patch_chromium.py
```

Stay in `tools` and run:

```
python3 generate_project.py --official
```

This will produce a project with the same settings that are used in official JxBrowser builds.

By default, the target cpu architecture corresponds to the current host architecture. If you want
to cross-compile for Apple Silicon chips, specify the `target_cpu` option explicitly:

```bash
python3 generate_project.py --official --target_cpu=arm64
```

Are you a TeamDev employee? See additional  [build steps][build-internal].

Build the project:

```bash
cd ../../
autoninja -C out/Release chrome
```

### Output files

When the build is finished, the `out/Release` directory will contain lots of files. You don't
need them all. In order to extract the required ones, use the `publish_binaries.py` script:

```
cd browsercore/tools
python3 publish_binaries.py
```

The binaries will be copied to the `browsercore/target/bin` directory.

### Binaries for JxBrowser

If you plan to build a JxBrowser distribution, compress the binaries into a single archive:

```bash
python3 7zr.py
```

The archive and the corresponding `*.info` file will be created in `browsercore/target` directory.

By default, the name of the resulting archive will match the OS and CPU architecture of
the current host. If you want to compress binaries for other platforms, specify the `target_cpu`
and `target_os` options explicitly:

```bash
python3 7zr.py --target_cpu=arm64 --target_os=mac
```

Lastly, create the `chromium.version` file that is required for JxBrowser build.

```bash
python3 generate_chromium_version.py
```

The file will be created in `browsercore/target` directory.

[mac_build_instructions.md]: https://chromium.googlesource.com/chromium/src/+/142.0.7444.176/docs/mac_build_instructions.md

[build-internal]: build_instructions_internal.md
