// Copyright (c) 2000-2025 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef INCLUDE_PLATINUM_GPU_FACTORY_H_
#define INCLUDE_PLATINUM_GPU_FACTORY_H_

#include <memory>

#include "components/viz/service/display_embedder/skia_output_surface_impl.h"
#include "components/viz/service/display_embedder/skia_output_surface_impl_on_gpu.h"

namespace platinum {

std::unique_ptr<viz::OutputSurface> CreateSoftwareOutputSurface(
    std::unique_ptr<viz::SoftwareOutputDevice> software_device);

std::unique_ptr<viz::SkiaOutputSurfaceImpl> CreateSkiaOutputSurface(
    base::PassKey<viz::SkiaOutputSurfaceImpl> pass_key,
    viz::DisplayCompositorMemoryAndTaskController* display_controller,
    const viz::RendererSettings& renderer_settings,
    const viz::DebugRendererSettings* debug_settings);

std::unique_ptr<viz::SkiaOutputSurfaceImplOnGpu> CreateSkiaOutputSurfaceOnGpu(
    base::PassKey<viz::SkiaOutputSurfaceImplOnGpu> pass_key,
    viz::SkiaOutputSurfaceDependency* deps,
    scoped_refptr<gpu::gles2::FeatureInfo> feature_info,
    const viz::RendererSettings& renderer_settings,
    gpu::DisplayCompositorMemoryAndTaskControllerOnGpu* shared_gpu_deps,
    viz::SkiaOutputSurfaceImplOnGpu::DidSwapBufferCompleteCallback
        did_swap_buffer_complete_callback,
    viz::SkiaOutputSurfaceImplOnGpu::BufferPresentedCallback buffer_presented_callback,
    viz::SkiaOutputSurfaceImplOnGpu::ContextLostCallback context_lost_callback,
    viz::SkiaOutputSurfaceImplOnGpu::ScheduleGpuTaskCallback schedule_gpu_task,
    viz::SkiaOutputSurfaceImplOnGpu::AddChildWindowToBrowserCallback
        add_child_window_to_browser_callback,
    viz::SkiaOutputDevice::ReleaseOverlaysCallback release_overlays_callback);

}  // namespace platinum

#endif  // INCLUDE_PLATINUM_GPU_FACTORY_H_
