// Copyright (c) 2000-2025 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef CORE_MAIN_DELEGATE_H_
#define CORE_MAIN_DELEGATE_H_

#include "chrome/app/chrome_main_delegate.h"

namespace platinum {

class MainDelegate : public ChromeMainDelegate {
 public:
  explicit MainDelegate(const StartupTimestamps& timestamps);

  MainDelegate(const MainDelegate&) = delete;
  MainDelegate& operator=(const MainDelegate&) = delete;

  ~MainDelegate() override;

 protected:
  std::optional<int> BasicStartupComplete() override;

#if BUILDFLAG(IS_MAC)
  void InitMacCrashReporter(const base::CommandLine& command_line,
                            const std::string& process_type) override;
#endif

  content::ContentClient* CreateContentClient() override;
  content::ContentBrowserClient* CreateContentBrowserClient() override;
  content::ContentRendererClient* CreateContentRendererClient() override;
  content::ContentGpuClient* CreateContentGpuClient() override;
  content::ContentUtilityClient* CreateContentUtilityClient() override;
};

}  // namespace platinum

#endif  // CORE_MAIN_DELEGATE_H_
