// Copyright (c) 2000-2025 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef CORE_MAIN_WEB_DIALOG_WIDGET_INFO_UPDATER_MAC_H_
#define CORE_MAIN_WEB_DIALOG_WIDGET_INFO_UPDATER_MAC_H_

#include <string>

#if defined(__OBJC__)
@class NSEvent;
#else
class NSEvent;
#endif  // CORE_WIDGET_INFO_UPDATER_MAC_H_

namespace input {
struct NativeWebKeyboardEvent;
}

namespace content {
class WebContents;
}  // namespace content

namespace views {
class Widget;
}  // namespace views

namespace platinum {
class BrowserImpl;

void DispatchWebContentsInfo(content::WebContents* web_contents);
void DispatchDialogWebContentsInfo(views::Widget* dialog_widget,
                                   content::WebContents* web_dialog_contents,
                                   content::WebContents* parent_web_contents);
// Returns |true| if the |key_event| was dispatched on the |dialog|.
bool DispatchKeyboardEvent(views::Widget* dialog, NSEvent* key_event);
bool DispatchKeyboardEvent(views::Widget* dialog, const input::NativeWebKeyboardEvent& key_event);
void DispatchKeyboardEvent(BrowserImpl* browser, NSEvent* request);

}  // namespace platinum

#endif  // CORE_MAIN_WEB_DIALOG_WIDGET_INFO_UPDATER_MAC_H_
