/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.callback.internal;

import com.teamdev.jxbrowser.browser.callback.internal.ShowTextReplacementMenuCallback;
import com.teamdev.jxbrowser.browser.internal.TextReplacementMenu;
import com.teamdev.jxbrowser.browser.internal.rpc.ShowTextReplacementMenu;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultCallback;
import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.stage.Window;

public class DefaultShowTextReplacementMenuCallback
extends DefaultCallback
implements ShowTextReplacementMenuCallback {
    public DefaultShowTextReplacementMenuCallback(BrowserView parent) {
        super(parent);
    }

    public ShowTextReplacementMenuCallback.Response on(ShowTextReplacementMenu.Request params) {
        CompletableFuture windowHandleFuture = new CompletableFuture();
        Platform.runLater(() -> {
            Optional<Window> window = this.window();
            if (window.isPresent()) {
                Optional<Long> nativeId = NativeAwareWindow.newInstance(window.get()).findNativeId();
                nativeId.ifPresentOrElse(windowHandleFuture::complete, () -> windowHandleFuture.complete(0L));
            } else {
                windowHandleFuture.complete(0L);
            }
        });
        try {
            Rect occludedRect = params.occludedRect();
            Rect rect = Rect.of((int)occludedRect.x(), (int)occludedRect.y(), (int)occludedRect.width(), (int)occludedRect.height());
            String selectedSuggestion = TextReplacementMenu.show((long)((Long)windowHandleFuture.get()), (Rect)rect, (String)params.primaryString(), (List)params.suggestions());
            return ShowTextReplacementMenuCallback.Response.select((String)selectedSuggestion);
        }
        catch (InterruptedException | ExecutionException e) {
            return ShowTextReplacementMenuCallback.Response.dismiss();
        }
    }
}

