/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.ScaleFactor;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.stage.Window;

public class DisplayWatcher
extends com.teamdev.jxbrowser.internal.DisplayWatcher<NativeAwareWindow> {
    private final ChangeListener<Number> scaleFactorListener;
    private final ChangeListener<Boolean> windowShowingListener;
    private final ChangeListener<Number> windowLocationListener = (property, oldValue, newValue) -> this.notifyWindowStateChanged();
    private NativeAwareWindow window;

    private DisplayWatcher(Consumer<Display> observer) {
        super(observer);
        this.windowShowingListener = (property, oldValue, newValue) -> this.notifyWindowStateChanged();
        this.scaleFactorListener = (property, oldValue, newValue) -> this.notifyWindowStateChanged();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void attach(NativeAwareWindow newWindow) {
        Preconditions.checkNotNull((Object)newWindow);
        if (this.isAttached()) {
            if (this.window.toolkitWindow() != newWindow.toolkitWindow()) {
                throw new IllegalStateException("DisplayWatcher must be detached");
            }
        } else {
            this.window = newWindow;
            this.watchWindow(newWindow);
        }
    }

    public void detach() {
        if (this.isAttached()) {
            this.unwatchWindow(this.window);
            this.window = null;
        }
    }

    private Optional<Long> windowHandle() {
        if (this.window == null) {
            return Optional.empty();
        }
        return this.window.findNativeId();
    }

    private Optional<Display> findNearestDisplay() {
        return this.windowHandle().map(windowHandle -> {
            String displayId = ToolkitLibrary.instance().getDisplayIdForWindowAndScale(windowHandle.longValue(), this.scaleFactor());
            double scaleFactor = ScaleFactor.forDisplay((String)displayId);
            return Display.newInstance((String)displayId, (double)scaleFactor);
        });
    }

    private void notifyWindowStateChanged() {
        this.findNearestDisplay().ifPresent(x$0 -> this.changeDisplay((Display)x$0));
    }

    private void watchWindow(NativeAwareWindow window) {
        Window toolkitWindow = window.toolkitWindow();
        toolkitWindow.xProperty().addListener(this.windowLocationListener);
        toolkitWindow.yProperty().addListener(this.windowLocationListener);
        toolkitWindow.showingProperty().addListener(this.windowShowingListener);
        this.renderScaleXProperty().addListener(this.scaleFactorListener);
        this.renderScaleYProperty().addListener(this.scaleFactorListener);
        this.notifyWindowStateChanged();
    }

    private void unwatchWindow(NativeAwareWindow window) {
        Window toolkitWindow = window.toolkitWindow();
        toolkitWindow.xProperty().removeListener(this.windowLocationListener);
        toolkitWindow.yProperty().removeListener(this.windowLocationListener);
        toolkitWindow.showingProperty().removeListener(this.windowShowingListener);
        this.renderScaleXProperty().removeListener(this.scaleFactorListener);
        this.renderScaleYProperty().removeListener(this.scaleFactorListener);
    }

    private boolean isAttached() {
        return this.window != null;
    }

    private DoubleProperty renderScaleXProperty() {
        return this.window.toolkitWindow().renderScaleXProperty();
    }

    private DoubleProperty renderScaleYProperty() {
        return this.window.toolkitWindow().renderScaleYProperty();
    }

    private double scaleFactor() {
        return this.window.toolkitWindow().getRenderScaleX();
    }

    public static final class Builder {
        private Consumer<Display> onDisplayChanged;

        public Builder onDisplayChanged(Consumer<Display> onDisplayChanged) {
            Preconditions.checkNotNull(onDisplayChanged);
            this.onDisplayChanged = onDisplayChanged;
            return this;
        }

        public DisplayWatcher build() {
            if (Environment.isLinux()) {
                return new LinuxDisplayWatcher();
            }
            return new DisplayWatcher(this.onDisplayChanged);
        }
    }

    private static final class LinuxDisplayWatcher
    extends DisplayWatcher {
        private LinuxDisplayWatcher() {
            super(display -> {});
        }

        public Display display() {
            return Display.primaryDisplay();
        }

        @Override
        public void attach(NativeAwareWindow window) {
        }

        @Override
        public void detach() {
        }
    }
}

