/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.javafx.internal.ClosestParentTab;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Tab;

public final class ParentTabTracker {
    private final Node node;
    private final TabSelectionListener tabListener;
    private final Runnable whenSelectedCallback;
    private final Runnable whenDeselectedCallback;
    private Tab watchedTab;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ParentTabTracker(Builder builder) {
        this.node = builder.node;
        this.tabListener = new TabSelectionListener();
        this.whenSelectedCallback = builder.whenSelectedCallback;
        this.whenDeselectedCallback = builder.whenDeselectedCallback;
    }

    void attach() {
        Optional<Tab> tab = ClosestParentTab.ofNode(this.node);
        tab.ifPresent(this::attachListener);
    }

    public void detach() {
        if (this.watchedTab != null) {
            this.detachListener();
        }
    }

    public void reattach() {
        this.detach();
        this.attach();
    }

    private void attachListener(Tab tab) {
        this.watchedTab = tab;
        this.watchedTab.selectedProperty().addListener((ChangeListener)this.tabListener);
    }

    private void detachListener() {
        if (this.watchedTab != null) {
            this.watchedTab.selectedProperty().removeListener((ChangeListener)this.tabListener);
            this.watchedTab = null;
        }
    }

    public static class Builder {
        private Node node;
        private Runnable whenSelectedCallback;
        private Runnable whenDeselectedCallback;

        public Builder forNode(Node node) {
            this.node = node;
            return this;
        }

        public Builder whenTabSelected(Runnable whenSelected) {
            this.whenSelectedCallback = whenSelected;
            return this;
        }

        public Builder whenTabDeselected(Runnable whenDeselected) {
            this.whenDeselectedCallback = whenDeselected;
            return this;
        }

        public ParentTabTracker build() {
            Preconditions.checkNotNull((Object)this.node);
            Preconditions.checkNotNull((Object)this.whenSelectedCallback);
            Preconditions.checkNotNull((Object)this.whenDeselectedCallback);
            return new ParentTabTracker(this);
        }
    }

    private final class TabSelectionListener
    implements ChangeListener<Boolean> {
        private TabSelectionListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                ParentTabTracker.this.whenSelectedCallback.run();
            } else {
                ParentTabTracker.this.whenDeselectedCallback.run();
            }
        }
    }
}

