/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.NativeEventListener;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.InputMethods;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

final class FocusListener
implements ChangeListener<Boolean> {
    private final InputMethods ime;
    private final BrowserWidget widget;
    private final NativeEventListener eventListener;
    private Node node;
    private boolean skipUnfocus;

    FocusListener(BrowserWidget widget, InputMethods ime, NativeEventListener eventListener) {
        this.ime = ime;
        this.widget = widget;
        this.eventListener = eventListener;
    }

    void skipUnfocus(boolean skipUnfocus) {
        this.skipUnfocus = skipUnfocus;
    }

    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (this.widget.isClosed()) {
            return;
        }
        if (this.node != null && this.node.isFocused()) {
            this.widget.focus();
            this.eventListener.focusGained();
        } else if (!this.skipUnfocus) {
            this.widget.unfocus();
            this.eventListener.focusLost();
            if (this.ime.isComposingImeText()) {
                this.ime.cancelImeComposition(true);
            }
        }
    }

    void attach(Node node) {
        this.node = node;
        this.node.focusedProperty().addListener((ChangeListener)this);
    }

    void detach() {
        if (this.node != null) {
            this.node.focusedProperty().removeListener((ChangeListener)this);
        }
        this.node = null;
    }
}

