/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateWebDialogLayerCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateWebDialogSurfaceCallback;
import com.teamdev.jxbrowser.browser.internal.callback.WebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogBoundsUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateDialogLayer;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateDialogSurface;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.view.internal.mac.NsView;
import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.scene.Node;

final class IoSurfaceWebDialogView {
    private final Node parent;
    private final NsView nsView;

    IoSurfaceWebDialogView(BrowserWidget widget, Node parent, WebDialog dialog) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)dialog);
        this.parent = parent;
        this.nsView = new NsView(widget);
        dialog.set(UpdateWebDialogSurfaceCallback.class, (WebDialogCallback)((UpdateWebDialogSurfaceCallback)params -> {
            this.nsView.updateSurface(params.getSurfaceId(), params.getScaleFactor(), true);
            return UpdateDialogSurface.Response.newBuilder().build();
        }));
        dialog.set(UpdateWebDialogLayerCallback.class, (WebDialogCallback)((UpdateWebDialogLayerCallback)params -> {
            this.nsView.setNsViewLayer(params.getContextId(), params.getScaleFactor(), true);
            return UpdateDialogLayer.Response.newBuilder().build();
        }));
        dialog.on(DialogBoundsUpdated.class, event -> this.nsView.updateBounds(this.centeredRelativeToWindowRect((Rect)event.getBounds())));
        dialog.on(DialogClosed.class, event -> Platform.runLater(() -> ((NsView)this.nsView).close()));
    }

    private Rect centeredRelativeToWindowRect(Rect bounds) {
        Bounds parentBoundsInScene = this.parent.localToScene(this.parent.getBoundsInLocal());
        int x = bounds.x() + (int)parentBoundsInScene.getMinX();
        int y = bounds.y() + (int)parentBoundsInScene.getMinY();
        return Rect.of((int)x, (int)y, (int)bounds.width(), (int)bounds.height());
    }

    public void show(long parentNsViewId, Rect initialBounds) {
        this.nsView.show(parentNsViewId, this.centeredRelativeToWindowRect(initialBounds));
    }
}

