/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.BrowserCallback;
import com.teamdev.jxbrowser.browser.callback.CreatePopupCallback;
import com.teamdev.jxbrowser.browser.callback.internal.ShowTextReplacementMenuCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.ShowDropdownCallback;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.internal.DefaultCallbacks;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ui.HeadlessToolkits;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.DragAndDrop;
import com.teamdev.jxbrowser.view.swing.callback.DefaultAlertCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultBeforeFormRepostCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultBeforeUnloadCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultConfirmCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenExtensionActionPopupCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenExternalAppCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenFileCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenFilesCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenFolderCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenPopupCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultPrintCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultPromptCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultRequestPdfDocumentPasswordCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSaveAsPdfCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSaveCreditCardCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSaveFileCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSavePasswordCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSaveUserDataProfileCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSelectClientCertificateCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSelectColorCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultShowContextMenuCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultShowDropdownCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultStartCaptureSessionCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultStartDownloadCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultUpdatePasswordCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultUpdateUserDataProfileCallback;
import com.teamdev.jxbrowser.view.swing.callback.internal.DefaultShowSuggestionsCallback;
import com.teamdev.jxbrowser.view.swing.callback.internal.DefaultShowTextReplacementMenuCallback;
import com.teamdev.jxbrowser.view.swing.internal.BrowserComponent;
import com.teamdev.jxbrowser.view.swing.internal.Graphics2dRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.IoSurfaceRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.WindowedWidget;
import com.teamdev.jxbrowser.view.swing.internal.menu.SuggestionsListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class BrowserView
extends JComponent {
    private static final String SWING_SCALE_PROPERTY = "sun.java2d.uiScale";
    private final BrowserImpl browser;
    private final DragAndDrop dragAndDrop;
    private final DefaultCallbacks<BrowserCallback> defaultCallbacks;
    private final RenderingMode renderingMode;
    private Subscription onBrowserClosed;
    private final BrowserComponent browserComponent;

    public static BrowserView newInstance(Browser browser) {
        return new BrowserView(browser);
    }

    private BrowserView(Browser browser) {
        Preconditions.checkNotNull((Object)browser);
        Logger.debug((String)"UI Toolkit: Swing");
        boolean nativeInputMethod = Boolean.getBoolean("jxbrowser.native.input.enabled");
        Logger.debug((String)String.format("Input method: %s", nativeInputMethod ? "native" : "Java"));
        this.browser = (BrowserImpl)browser;
        this.renderingMode = browser.engine().options().renderingMode();
        if (Environment.isLinux()) {
            double scaleFactor = 1.0;
            if (SystemProperties.hasProperty((String)SWING_SCALE_PROPERTY)) {
                try {
                    scaleFactor = Double.max((int)Double.parseDouble(System.getProperty(SWING_SCALE_PROPERTY)), 1.0);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.browser.widget().setForcedScaleFactor(scaleFactor);
        }
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 600));
        this.defaultCallbacks = this.defaultCallbacks();
        this.browserComponent = this.createBrowserWidget();
        this.addWidget(this.browserComponent.asComponent());
        SuggestionsListener suggestionsListener = new SuggestionsListener(browser);
        this.onBrowserClosed = browser.on(BrowserClosed.class, event -> {
            this.removeWidget(this.browserComponent.asComponent());
            this.defaultCallbacks.unregister();
            suggestionsListener.stopEventsProcessing();
            this.onBrowserClosed.unsubscribe();
            this.unregisterCustomDropdownIfNecessary();
            this.unregisterTextCompletionCallbackIfNecessary();
        });
        this.dragAndDrop = new DragAndDropSupport();
        suggestionsListener.startEventsProcessing();
        this.defaultCallbacks.register();
    }

    private void removeWidget(JComponent widget) {
        SwingUtilities.invokeLater(() -> {
            this.remove(widget);
            this.validate();
            this.repaint();
        });
    }

    private void addWidget(JComponent widget) {
        SwingUtilities.invokeLater(() -> {
            this.add((Component)widget, "Center");
            this.validate();
            this.repaint();
        });
    }

    private BrowserWidget widget() {
        return this.browser.widget();
    }

    private DefaultCallbacks<BrowserCallback> defaultCallbacks() {
        this.registerCustomDropdownIfNecessary();
        this.registerTextCompletionCallbackIfNecessary();
        return DefaultCallbacks.of((Advisable)this.browser).add((Callback)((CreatePopupCallback)params -> CreatePopupCallback.Response.create())).add((Callback)new DefaultOpenPopupCallback()).add((Callback)new DefaultAlertCallback(this)).add((Callback)new DefaultConfirmCallback(this)).add((Callback)new DefaultPromptCallback(this)).add((Callback)new DefaultOpenFileCallback(this)).add((Callback)new DefaultOpenFilesCallback(this)).add((Callback)new DefaultOpenFolderCallback(this)).add((Callback)new DefaultSaveFileCallback(this)).add((Callback)new DefaultSaveAsPdfCallback(this)).add((Callback)new DefaultSelectColorCallback(this)).add((Callback)new DefaultBeforeUnloadCallback(this)).add((Callback)new DefaultSelectClientCertificateCallback(this)).add((Callback)new DefaultBeforeFormRepostCallback(this)).add((Callback)new DefaultPrintCallback()).add((Callback)new DefaultShowContextMenuCallback(this)).add((Callback)new DefaultStartDownloadCallback(this)).add((Callback)new DefaultStartCaptureSessionCallback()).add((Callback)new DefaultOpenExternalAppCallback(this)).add((Callback)new DefaultShowSuggestionsCallback(this)).add((Callback)new DefaultSavePasswordCallback(this)).add((Callback)new DefaultUpdatePasswordCallback(this)).add((Callback)new DefaultSaveCreditCardCallback(this)).add((Callback)new DefaultSaveUserDataProfileCallback(this)).add((Callback)new DefaultUpdateUserDataProfileCallback(this)).add((Callback)new DefaultRequestPdfDocumentPasswordCallback(this)).add((Callback)new DefaultOpenExtensionActionPopupCallback()).build();
    }

    private void registerCustomDropdownIfNecessary() {
        if (this.isCustomDropdownsEnabled()) {
            this.widget().set(ShowDropdownCallback.class, (BrowserWidgetCallback)new DefaultShowDropdownCallback(this));
        }
    }

    private void registerTextCompletionCallbackIfNecessary() {
        if (this.isMacNativeInput()) {
            this.browser.set(ShowTextReplacementMenuCallback.class, (BrowserCallback)new DefaultShowTextReplacementMenuCallback(this));
        }
    }

    private void unregisterCustomDropdownIfNecessary() {
        if (this.isMacNativeInput()) {
            this.browser.widget().remove(ShowDropdownCallback.class);
        }
    }

    private void unregisterTextCompletionCallbackIfNecessary() {
        boolean nativeInputMethod = Boolean.getBoolean("jxbrowser.native.input.enabled");
        if (nativeInputMethod && Environment.isMac()) {
            this.browser.remove(ShowTextReplacementMenuCallback.class);
        }
    }

    private boolean isCustomDropdownsEnabled() {
        return HeadlessToolkits.isHeadlessToolkit() && this.renderingMode == RenderingMode.OFF_SCREEN;
    }

    private boolean isMacNativeInput() {
        return Environment.isMac() && Boolean.getBoolean("jxbrowser.native.input.enabled");
    }

    private BrowserComponent createBrowserWidget() {
        if (this.renderingMode == RenderingMode.OFF_SCREEN) {
            return new Graphics2dRenderWidget(this.widget());
        }
        if (this.renderingMode == RenderingMode.HARDWARE_ACCELERATED) {
            if (Environment.isMac()) {
                return new IoSurfaceRenderWidget(this.widget());
            }
            if (Environment.isWindows() || Environment.isLinux()) {
                return new WindowedWidget(this.widget());
            }
        }
        throw new IllegalStateException("Unsupported operating system");
    }

    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.browserComponent != null) {
            this.browserComponent.asComponent().requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        if (this.browserComponent != null) {
            return this.browserComponent.asComponent().requestFocus(temporary);
        }
        return super.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.browserComponent != null) {
            return this.browserComponent.asComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.browserComponent != null) {
            this.browserComponent.asComponent().setVisible(visible);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.browserComponent != null) {
            this.browserComponent.asComponent().setEnabled(enabled);
        }
    }

    public DragAndDrop dragAndDrop() {
        return this.dragAndDrop;
    }

    private class DragAndDropSupport
    implements DragAndDrop {
        private DragAndDropSupport() {
        }

        @Override
        public void enable() {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            BrowserView.this.browser.dragAndDrop().enable();
            if (BrowserView.this.browserComponent != null) {
                BrowserView.this.browserComponent.enableDragAndDrop();
            }
        }

        @Override
        public void disable() {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (BrowserView.this.browserComponent != null) {
                BrowserView.this.browserComponent.disableDragAndDrop();
            }
            BrowserView.this.browser.dragAndDrop().disable();
        }

        @Override
        public boolean isEnabled() {
            if (GraphicsEnvironment.isHeadless()) {
                return false;
            }
            return BrowserView.this.browser.dragAndDrop().isEnabledSync();
        }

        @Override
        public void enableExternalDrag() {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (BrowserView.this.browserComponent != null) {
                BrowserView.this.browserComponent.setEnabledExternalDrag(true);
            }
            BrowserView.this.browser.dragAndDrop().enableExternalDrag();
        }

        @Override
        public void disableExternalDrag() {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (BrowserView.this.browserComponent != null) {
                BrowserView.this.browserComponent.setEnabledExternalDrag(false);
            }
            BrowserView.this.browser.dragAndDrop().disableExternalDrag();
        }

        @Override
        public boolean isExternalDragEnabled() {
            if (GraphicsEnvironment.isHeadless()) {
                return false;
            }
            return BrowserView.this.browser.dragAndDrop().isExternalDragEnabledSync();
        }
    }
}

