/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.callback.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.browser.event.UpdateBoundsRequested;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.ApproximateBounds;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import com.teamdev.jxbrowser.view.swing.internal.ToolkitConverters;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class OpenBrowserPopupCallback {
    protected static final Size DEFAULT_POPUP_SIZE = Size.of((int)800, (int)600);

    protected void integrateBrowser(final Browser browser, Rect initialBounds) {
        SwingUtilities.invokeLater(() -> {
            BrowserView view = BrowserView.newInstance(browser);
            JFrame frame = new JFrame();
            frame.add((Component)view, "Center");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SwingUtilities.invokeLater(() -> ((Browser)browser).close());
                }
            });
            this.configureFrame(frame);
            OpenBrowserPopupCallback.updateInitialBounds(frame, initialBounds);
            browser.on(TitleChanged.class, event -> SwingUtilities.invokeLater(() -> frame.setTitle(event.title())));
            browser.on(BrowserClosed.class, event -> SwingUtilities.invokeLater(() -> {
                frame.setVisible(false);
                frame.dispose();
            }));
            browser.on(UpdateBoundsRequested.class, event -> this.updateBounds((UpdateBoundsRequested)event, frame, view));
            frame.setVisible(true);
        });
    }

    protected void configureFrame(JFrame frame) {
    }

    private void updateBounds(UpdateBoundsRequested event, JFrame frame, BrowserView view) {
        SwingUtilities.invokeLater(() -> {
            Rect popupBounds = event.bounds();
            Size popupSize = popupBounds.size();
            if (!ApproximateBounds.fuzzyEqual((Size)OpenBrowserPopupCallback.currentSize(view), (Size)popupSize)) {
                OpenBrowserPopupCallback.updateSize(frame, popupSize);
                frame.pack();
            }
            if (!ApproximateBounds.fuzzyEqual((Point)OpenBrowserPopupCallback.currentOrigin(view), (Point)popupBounds.origin())) {
                OpenBrowserPopupCallback.updateOrigin(frame, popupBounds.origin());
            }
        });
    }

    private static Point currentOrigin(BrowserView view) {
        java.awt.Point locationOnScreen = view.getLocationOnScreen();
        return Geometry.newPoint((double)locationOnScreen.getX(), (double)locationOnScreen.getY());
    }

    private static Size currentSize(BrowserView view) {
        Rectangle bounds = view.getBounds();
        return Size.of((int)bounds.width, (int)bounds.height);
    }

    private static void updateInitialBounds(JFrame frame, Rect bounds) {
        OpenBrowserPopupCallback.updateOrigin(frame, bounds.origin());
        OpenBrowserPopupCallback.updateSize(frame, bounds.size());
        frame.pack();
    }

    private static void updateOrigin(JFrame frame, Point origin) {
        frame.setLocation(ToolkitConverters.toPoint(origin));
    }

    private static void updateSize(JFrame frame, Size size) {
        if (size.isEmpty()) {
            frame.setSize(ToolkitConverters.toDimension(DEFAULT_POPUP_SIZE));
        } else {
            frame.getContentPane().setPreferredSize(ToolkitConverters.toDimension(size));
        }
    }
}

