/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.internal.MacPasteboard;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.internal.CustomTypeMimeType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.CustomDataEnvelope;
import com.teamdev.jxbrowser.view.swing.internal.dnd.CustomDataSupport;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.RichDataFlavor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

final class CustomDataType
extends DataType {
    static final DataFlavor CUSTOM_DATA_FLAVOR = new DataFlavor(CustomTypeMimeType.value(), "Chromium Custom Data Types");

    CustomDataType() {
    }

    @Override
    public void fillDropData(Transferable transferable, DropData.Builder dropData) {
        try {
            this.customData(transferable).ifPresent(byteString -> {
                DropData.CustomData data = this.wrap((ByteString)byteString);
                dropData.setCustomData(data);
            });
        }
        catch (UnsupportedFlavorException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    boolean isPresentedIn(Transferable transferable) {
        return Arrays.stream(transferable.getTransferDataFlavors()).anyMatch(CustomDataSupport::isCustomDataFlavor);
    }

    @Override
    void fillMetadata(Transferable transferable, DropMetadata.Builder metadata) {
        CustomDataType.findCustomTypes(transferable).forEach(arg_0 -> ((DropMetadata.Builder)metadata).addCustomDataTypes(arg_0));
    }

    @Override
    public void fillMetadata(DropMetadata.Builder metadata) {
        throw new UnsupportedOperationException();
    }

    protected List<RichDataFlavor<?>> supportedFlavors() {
        return Collections.emptyList();
    }

    private DropData.CustomData wrap(ByteString data) {
        return DropData.CustomData.newBuilder().setAsBytes(data).build();
    }

    private Optional<ByteString> customData(Transferable transferable) throws IOException, UnsupportedFlavorException {
        ByteString result = null;
        if (transferable.isDataFlavorSupported(CustomDataSupport.ENVELOPED_CUSTOM_DATA)) {
            CustomDataEnvelope data = (CustomDataEnvelope)transferable.getTransferData(CustomDataSupport.ENVELOPED_CUSTOM_DATA);
            result = data.bytesString();
        } else {
            byte[] data;
            if (Environment.isMac() && (data = MacPasteboard.instance().readCustomData()).length > 0) {
                result = ByteString.copyFrom((byte[])data);
            }
            if (transferable.isDataFlavorSupported(CustomDataSupport.RAW_CUSTOM_DATA)) {
                data = (byte[])transferable.getTransferData(CustomDataSupport.RAW_CUSTOM_DATA);
                result = ByteString.copyFrom((byte[])data);
            }
        }
        return Optional.ofNullable(result);
    }

    private static List<String> findCustomTypes(Transferable transferable) {
        try {
            String flavorName = CUSTOM_DATA_FLAVOR.getHumanPresentableName();
            for (DataFlavor flavor : transferable.getTransferDataFlavors()) {
                if (!flavorName.equals(flavor.getHumanPresentableName())) continue;
                return (List)transferable.getTransferData(flavor);
            }
        }
        catch (UnsupportedFlavorException | IOException e) {
            Logger.warn((Throwable)e, () -> "Failed to read custom data types from the drag board");
        }
        return Collections.emptyList();
    }
}

